/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.cloudsuite.gears.core.config;

import jakarta.servlet.Filter;
import java.util.Collections;
import java.util.List;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.web.servlet.FilterRegistrationBean;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.web.cors.CorsConfiguration;
import org.springframework.web.cors.CorsConfigurationSource;
import org.springframework.web.cors.UrlBasedCorsConfigurationSource;
import org.springframework.web.filter.CorsFilter;
import org.springframework.web.servlet.config.annotation.WebMvcConfigurer;

@Configuration
public class CorsConfig
implements WebMvcConfigurer {
    @Value(value="${security.cors.allowedHeaders:*}")
    private List<String> allowedHeaders;
    @Value(value="${security.cors.allowedMethods:*}")
    private List<String> allowedMethods;
    @Value(value="${security.cors.allowedOrigins:}")
    private List<String> allowedOrigins;
    @Value(value="${security.cors.allowedOriginPatterns:*}")
    private List<String> allowedOriginPatterns;
    @Value(value="${security.cors.exposedHeaders:Content-Disposition}")
    private List<String> exposedHeaders;
    @Value(value="${security.cors.allowCredentials:true}")
    private Boolean allowCredentials;

    @Bean
    public FilterRegistrationBean cors() {
        CorsConfiguration config = new CorsConfiguration();
        config.setAllowedHeaders(this.allowedHeaders);
        config.setAllowedMethods(this.allowedMethods);
        config.setAllowedOrigins(this.allowedOrigins);
        config.setAllowedOriginPatterns(this.allowedOriginPatterns);
        config.setAllowCredentials(this.allowCredentials);
        config.setExposedHeaders(this.exposedHeaders);
        UrlBasedCorsConfigurationSource configSource = new UrlBasedCorsConfigurationSource();
        configSource.registerCorsConfiguration("/**", config);
        CorsFilter filter = new CorsFilter((CorsConfigurationSource)configSource);
        FilterRegistrationBean registration = new FilterRegistrationBean();
        registration.setFilter((Filter)filter);
        registration.setUrlPatterns(Collections.singletonList("/*"));
        registration.setName("cors");
        return registration;
    }
}

