/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.cloudsuite.gears.core.config;

import de.intarsys.cloudsuite.gears.core.config.PublishApplicationStart;
import de.intarsys.document.aspect.document.pdf.rendering.CwtPdfRenderer;
import de.intarsys.document.aspect.document.pdf.rendering.IRenderer;
import de.intarsys.document.aspect.document.pdf.rendering.PdfiumPdfRenderer;
import de.intarsys.document.aspect.type.rendering.RenderingParameters;
import de.intarsys.document.type.pdf.PDFDocument;
import de.intarsys.security.certificate.provider.ICertificateProviderRegistry;
import de.intarsys.security.certificate.provider.SpringCertificateProviderRegistry;
import de.intarsys.security.certificate.trustrepository.DefaultTrustRepository;
import de.intarsys.security.provider.BouncyCastleProviderInstaller;
import de.intarsys.security.provider.IntarsysProviderInstaller;
import de.intarsys.spring.listener.EagerInitializerListener;
import de.intarsys.spring.preferences.SpringMappedPreferences;
import de.intarsys.spring.properties.PropertySourceSubsetResolver;
import de.intarsys.spring.properties.SpringPropertiesElementConfigurationProvider;
import de.intarsys.spring.tools.RuntimePlaceholderConfigurer;
import de.intarsys.tools.application.ApplicationComponent;
import de.intarsys.tools.bean.IBeanInstallationInstruction;
import de.intarsys.tools.conversation.service.impl.ConversationServiceTools;
import de.intarsys.tools.expression.ExpressionDefinition;
import de.intarsys.tools.expression.PreferencesResolver;
import de.intarsys.tools.expression.VariableNamespacesResolver;
import de.intarsys.tools.license.LicenseProduct;
import de.intarsys.tools.locator.FileLocator;
import de.intarsys.tools.locator.ILocator;
import de.intarsys.tools.preferences.IPreferencesFactory;
import de.intarsys.tools.preferences.common.ScopedPreferencesFactory;
import de.intarsys.tools.ssl.ConfigurableSslContextProvider;
import de.intarsys.tools.ssl.ISslContextProvider;
import de.intarsys.tools.ui.toolkit.IToolkit;
import de.intarsys.tools.ui.toolkit.WebToolkit;
import de.intarsys.tools.variable.Variable;
import de.intarsys.tools.variable.VariableNamespace;
import de.intarsys.tools.webhook.api.IWebhookRegistry;
import de.intarsys.tools.webhook.impl.StandardWebhookRegistry;
import jakarta.annotation.PostConstruct;
import java.util.prefs.Preferences;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.ApplicationRunner;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.ComponentScan;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Primary;
import org.springframework.context.annotation.Scope;
import org.springframework.core.env.ConfigurableEnvironment;

@Configuration
@ComponentScan(value={"de.intarsys.component.spring"})
public class GearsCoreConfig {
    @Autowired
    private ConfigurableEnvironment env;
    @Value(value="${conversation.legacyIntegrationSupport:false}")
    private boolean legacyIntegrationSupport = false;

    @Bean
    public static RuntimePlaceholderConfigurer propertySourcesPlaceholderConfigurer() {
        return new RuntimePlaceholderConfigurer();
    }

    @Bean
    public ICertificateProviderRegistry certificateProviderRegistry() {
        return new SpringCertificateProviderRegistry();
    }

    @Bean
    public EagerInitializerListener eagerInitializer() {
        return new EagerInitializerListener();
    }

    @Bean
    public SpringPropertiesElementConfigurationProvider elementAdapter() {
        return new SpringPropertiesElementConfigurationProvider();
    }

    @Bean
    public ExpressionDefinition expressionDefinitionConfig() {
        return new ExpressionDefinition("config", (Object)this.expressionResolverConfig());
    }

    @Bean
    public ExpressionDefinition expressionDefinitionPreferences() {
        return new ExpressionDefinition("preferences", (Object)new PreferencesResolver.PreferencesResolverMain());
    }

    @Bean
    public ExpressionDefinition expressionDefinitionPreferencesRoot() {
        return new ExpressionDefinition("preferencesRoot", (Object)new PreferencesResolver.PreferencesResolverRoot());
    }

    @Bean
    public ExpressionDefinition expressionDefinitionVariables() {
        return new ExpressionDefinition("variables", (Object)new VariableNamespacesResolver());
    }

    @Bean
    public PropertySourceSubsetResolver expressionResolverConfig() {
        return new PropertySourceSubsetResolver("config");
    }

    @PostConstruct
    public void init() {
        ConversationServiceTools.setLegacyIntegrationSupport((boolean)this.legacyIntegrationSupport);
    }

    @Bean
    public LicenseProduct licenseProduct() {
        LicenseProduct product = new LicenseProduct();
        product.setId("de.intarsys.cloudsuite.product.gears");
        product.setVersion(ApplicationComponent.get().getVersion());
        product.setMain(true);
        product.setContext((Object)this);
        return product;
    }

    @Bean
    @Scope(value="prototype")
    public IRenderer pdfRendererCwt(PDFDocument document, int pageIndex, RenderingParameters renderParams) {
        return new CwtPdfRenderer(document, pageIndex, renderParams);
    }

    @Bean
    @Scope(value="prototype")
    public IRenderer pdfRendererPdfium(PDFDocument document, int pageIndex, RenderingParameters renderParams) {
        return new PdfiumPdfRenderer(document, pageIndex, renderParams);
    }

    @Bean
    public IPreferencesFactory preferences() {
        ScopedPreferencesFactory preferences = new ScopedPreferencesFactory();
        preferences.setMainName("de.intarsys.prefs.common");
        preferences.registerPreferences("SPRING", (Preferences)this.preferencesSpring(), false);
        String resolved = this.env.resolveRequiredPlaceholders("${cloudsuite.data.dir}/preferences");
        FileLocator scopeLocator = new FileLocator(resolved);
        preferences.registerPreferenceDirectory("USER", (ILocator)scopeLocator, true);
        return preferences;
    }

    @Bean
    public SpringMappedPreferences preferencesSpring() {
        SpringMappedPreferences preferences = new SpringMappedPreferences();
        preferences.getNameMapping().put("de.intarsys.prefs.security.deviceProviders", "deviceProviders");
        preferences.getNameMapping().put("de.intarsys.prefs.security.smartcard", "smartcard");
        preferences.getNameMapping().put("de.intarsys.prefs.security.digsig", "digsig");
        return preferences;
    }

    @Bean
    public IBeanInstallationInstruction providerInstallerBouncyCastle() {
        return new BouncyCastleProviderInstaller();
    }

    @Bean
    public IBeanInstallationInstruction providerInstallerIntarsys() {
        return new IntarsysProviderInstaller();
    }

    @Bean
    public ApplicationRunner runnerPublish() {
        return new PublishApplicationStart();
    }

    @Bean
    @Primary
    public ISslContextProvider sslContextProvider() {
        return new ConfigurableSslContextProvider();
    }

    @Bean
    public IToolkit toolkit() {
        return new WebToolkit();
    }

    @Bean
    public DefaultTrustRepository trustRepository() {
        return new DefaultTrustRepository();
    }

    @Bean
    public Variable variableGlobalGreeting() {
        this.variableNsGlobal();
        Variable bean = new Variable();
        bean.setNamespace("global");
        bean.setName("greeting");
        bean.setValue("hello, ${variables.global.name}");
        return bean;
    }

    @Bean
    public Variable variableGlobalName() {
        this.variableNsGlobal();
        Variable bean = new Variable();
        bean.setNamespace("global");
        bean.setName("company");
        bean.setValue("intarsys GmbH");
        return bean;
    }

    @Bean
    public VariableNamespace variableNsGlobal() {
        VariableNamespace bean = new VariableNamespace();
        bean.setId("global");
        bean.setPreferencesName("/de.intarsys.prefs.common/variables/global");
        bean.setPreferencesScope("GLOBAL");
        return bean;
    }

    @Bean
    public VariableNamespace variableNsUser() {
        VariableNamespace bean = new VariableNamespace();
        bean.setId("user");
        bean.setPreferencesName("/de.intarsys.prefs.common/variables/user");
        bean.setPreferencesScope("USER");
        return bean;
    }

    @Bean
    public Variable variableUserGreeting() {
        this.variableNsUser();
        Variable bean = new Variable();
        bean.setNamespace("user");
        bean.setName("greeting");
        bean.setValue("hello, ${variables.user.name}");
        return bean;
    }

    @Bean
    public Variable variableUserName() {
        this.variableNsUser();
        Variable bean = new Variable();
        bean.setNamespace("user");
        bean.setName("name");
        bean.setValue("[enter name]");
        return bean;
    }

    @Bean
    public IWebhookRegistry webhookRegistry() {
        return new StandardWebhookRegistry();
    }
}

