/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.cloudsuite.gears.core.config;

import com.fasterxml.jackson.jakarta.rs.json.JacksonJsonProvider;
import de.intarsys.cloudsuite.gears.service.decorate.ConversationalInvocationHandlerProvider;
import de.intarsys.cloudsuite.gears.service.jackson.ObjectMapperResolver;
import de.intarsys.spring.jaxrs.JaxrsConfigurationFeature;
import de.intarsys.tools.conversation.service.impl.SvcConversation;
import de.intarsys.tools.jaxrs.exception.JsonMappingExceptionMapper;
import de.intarsys.tools.jaxrs.exception.JsonParseExceptionMapper;
import de.intarsys.tools.jaxrs.interceptor.FilterExceptionInterceptor;
import de.intarsys.tools.jaxrs.logging.LoggingFeature;
import io.swagger.v3.jaxrs2.integration.resources.AcceptHeaderOpenApiResource;
import io.swagger.v3.jaxrs2.integration.resources.OpenApiResource;
import jakarta.annotation.PostConstruct;
import jakarta.ws.rs.ApplicationPath;
import org.glassfish.hk2.utilities.binding.AbstractBinder;
import org.glassfish.jersey.media.multipart.MultiPartFeature;
import org.glassfish.jersey.server.ResourceConfig;
import org.glassfish.jersey.server.spi.internal.ResourceMethodInvocationHandlerProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.event.Level;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Bean;
import org.springframework.stereotype.Component;

@Component
@ApplicationPath(value="/api")
public class JerseyConfig
extends ResourceConfig {
    private static final String VALUE_TRUE = "true";
    @Autowired
    private JaxrsConfigurationFeature jaxrsConfigurationFeature;

    @Bean
    public static JaxrsConfigurationFeature jaxrsConfigurationFeature() {
        return new JaxrsConfigurationFeature();
    }

    @PostConstruct
    public void init() {
        this.property("jersey.config.server.wadl.disableWadl", VALUE_TRUE);
        this.property("com.sun.jersey.config.feature.DisableWADL", VALUE_TRUE);
        this.register(new AbstractBinder(){

            protected void configure() {
                this.bind(ConversationalInvocationHandlerProvider.class).to(ResourceMethodInvocationHandlerProvider.class);
            }
        });
        this.register(MultiPartFeature.class);
        this.register(ObjectMapperResolver.class);
        this.register(JacksonJsonProvider.class);
        this.register(JsonParseExceptionMapper.class);
        this.register(JsonMappingExceptionMapper.class);
        this.register(FilterExceptionInterceptor.class);
        this.register(this.jaxrsConfigurationFeature);
        this.packages(new String[]{"de.intarsys.security.auth.service", "de.intarsys.cloudsuite"});
        this.register(SvcConversation.class);
        Logger logger = LoggerFactory.getLogger((String)"jaxrs");
        if (logger.isEnabledForLevel(Level.DEBUG)) {
            LoggingFeature feature = new LoggingFeature(logger, Level.DEBUG, LoggingFeature.Verbosity.PAYLOAD_TEXT, Integer.valueOf(1000));
            this.register(feature);
        }
        this.register(OpenApiResource.class);
        this.register(AcceptHeaderOpenApiResource.class);
    }
}

