/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.cloudsuite.gears.core.config;

import de.intarsys.spring.jaxrs.Registration;
import de.intarsys.tools.collection.ListTools;
import de.intarsys.tools.jaxrs.IRequestContext;
import de.intarsys.tools.loadbalance.ILoadBalanceContext;
import de.intarsys.tools.loadbalance.LoadBalanceFilter;
import de.intarsys.tools.loadbalance.LoadBalanceRequestContext;
import de.intarsys.tools.loadbalance.LoadBalanceRequestFilter;
import de.intarsys.tools.loadbalance.StandardLoadBalanceContext;
import de.intarsys.tools.string.StringTools;
import jakarta.servlet.Filter;
import java.util.Collection;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.web.servlet.FilterRegistrationBean;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Profile;

@Configuration
@Profile(value={"loadbalance"})
public class LoadBalanceConfig {
    @Value(value="${loadbalance.cookieName:}")
    private String cookieName;
    @Value(value="${loadbalance.cookieValue:}")
    private String cookieValue;
    @Value(value="${loadbalance.cookieDomain:}")
    private String cookieDomain;
    @Value(value="${loadbalance.cookiePath:}")
    private String cookiePath;
    @Value(value="${loadbalance.cookieHttpOnly:true}")
    private boolean cookieHttpOnly;
    @Value(value="${loadbalance.cookieSecure:false}")
    private boolean cookieSecure;
    @Value(value="${loadbalance.cookieMaxAge:-1}")
    private int cookieMaxAge;

    @Bean
    public ILoadBalanceContext loadBalanceContext() {
        StandardLoadBalanceContext result = new StandardLoadBalanceContext();
        if (!StringTools.isEmpty((String)this.cookieDomain)) {
            result.setCookieDomain(this.cookieDomain);
        }
        if (!StringTools.isEmpty((String)this.cookiePath)) {
            result.setCookiePath(this.cookiePath);
        }
        if (!StringTools.isEmpty((String)this.cookieName)) {
            result.setCookieName(this.cookieName);
        }
        if (!StringTools.isEmpty((String)this.cookieValue)) {
            result.setCookieValue(this.cookieValue);
        }
        result.setCookieHttpOnly(this.cookieHttpOnly);
        result.setCookieMaxAge(this.cookieMaxAge);
        result.setCookieSecure(this.cookieSecure);
        return result;
    }

    @Bean
    public Registration loadBalanceRequestFilter() {
        return new Registration((Object)new LoadBalanceRequestFilter());
    }

    @Bean
    public IRequestContext requestContext() {
        return new LoadBalanceRequestContext();
    }

    @Bean
    public FilterRegistrationBean requestLoadBalanceFilter() {
        FilterRegistrationBean registration = new FilterRegistrationBean();
        registration.setFilter((Filter)new LoadBalanceFilter());
        registration.setUrlPatterns((Collection)ListTools.with((Object[])new String[]{"/*"}));
        registration.setName("LoadBalanceFilter");
        return registration;
    }
}

