/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.cloudsuite.gears.core.config;

import de.intarsys.spring.webmvc.AngularAppHttpRequestHandler;
import de.intarsys.spring.webmvc.WTFEverythingIsPrivateErrorViewResolver;
import de.intarsys.tools.correlation.CorrelationFilter;
import de.intarsys.tools.environment.file.FileEnvironment;
import de.intarsys.tools.servlet.filter.AccessLogFilter;
import de.intarsys.tools.servlet.filter.CallContextFilter;
import de.intarsys.tools.servlet.filter.LanguageFilter;
import jakarta.servlet.Filter;
import java.nio.file.Path;
import java.util.List;
import java.util.Map;
import org.springframework.beans.factory.ListableBeanFactory;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.config.BeanFactoryPostProcessor;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.support.BeanDefinitionRegistry;
import org.springframework.boot.autoconfigure.web.WebProperties;
import org.springframework.boot.autoconfigure.web.servlet.error.ErrorViewResolver;
import org.springframework.boot.web.servlet.FilterRegistrationBean;
import org.springframework.boot.web.servlet.ServletComponentScan;
import org.springframework.boot.web.servlet.ServletRegistrationBean;
import org.springframework.context.ApplicationContext;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.io.PathResource;
import org.springframework.core.io.Resource;
import org.springframework.security.web.access.intercept.AuthorizationFilter;
import org.springframework.security.web.access.intercept.FilterSecurityInterceptor;
import org.springframework.web.servlet.config.annotation.ViewControllerRegistry;
import org.springframework.web.servlet.config.annotation.WebMvcConfigurer;
import org.springframework.web.servlet.handler.SimpleUrlHandlerMapping;
import org.springframework.web.servlet.resource.ResourceHttpRequestHandler;

@Configuration
@ServletComponentScan(value={"de.intarsys"})
public class WebApplicationConfig
implements WebMvcConfigurer {
    private static <F extends Filter> void addDisabledRegistrations(ListableBeanFactory beanFactory, Class<F> filterType) {
        BeanDefinitionRegistry beanDefinitionRegistry = (BeanDefinitionRegistry)beanFactory;
        for (String filterBeanName : beanFactory.getBeanNamesForType(filterType, true, false)) {
            beanDefinitionRegistry.registerBeanDefinition(filterBeanName + "-auto-registration", WebApplicationConfig.createDisabledRegistrationBeanDefinition(beanFactory, filterBeanName));
        }
    }

    private static BeanDefinition createDisabledRegistrationBeanDefinition(ListableBeanFactory beanFactory, String filterBeanName) {
        return BeanDefinitionBuilder.genericBeanDefinition(FilterRegistrationBean.class, () -> {
            Filter filter = (Filter)beanFactory.getBean(filterBeanName, Filter.class);
            FilterRegistrationBean registration = new FilterRegistrationBean(filter, new ServletRegistrationBean[0]);
            registration.setEnabled(false);
            return registration;
        }).getBeanDefinition();
    }

    @Bean
    public static BeanFactoryPostProcessor preventDuplicateAuthorizationFilterRegistration() {
        return beanFactory -> {
            WebApplicationConfig.addDisabledRegistrations((ListableBeanFactory)beanFactory, AuthorizationFilter.class);
            WebApplicationConfig.addDisabledRegistrations((ListableBeanFactory)beanFactory, FilterSecurityInterceptor.class);
        };
    }

    public void addViewControllers(ViewControllerRegistry registry) {
        registry.addViewController("/").setViewName("forward:/ng/index.html");
    }

    private ResourceHttpRequestHandler createAngularAppHttpRequestHandler(String appName, String resourcePath) {
        Path profileDir = FileEnvironment.get().getProfileDir().toPath().toAbsolutePath();
        PathResource resource = new PathResource(profileDir.resolve(resourcePath));
        AngularAppHttpRequestHandler requestHandler = new AngularAppHttpRequestHandler();
        requestHandler.setAppName(appName);
        requestHandler.addOverrideLocation((Resource)resource);
        return requestHandler;
    }

    private <T extends Filter> FilterRegistrationBean<T> createFilterRegistration(String name, String urlPattern, T filter, int order) {
        FilterRegistrationBean registration = new FilterRegistrationBean();
        registration.setName(name);
        registration.setUrlPatterns(List.of(urlPattern));
        registration.setFilter(filter);
        registration.setOrder(order);
        return registration;
    }

    @Bean
    public ErrorViewResolver errorViewResolver(ApplicationContext applicationContext, WebProperties webProperties) {
        return new WTFEverythingIsPrivateErrorViewResolver(applicationContext, webProperties);
    }

    @Bean
    public FilterRegistrationBean<AccessLogFilter> filterAccessLog() {
        return this.createFilterRegistration("AccessLog", "/*", new AccessLogFilter(), 3);
    }

    @Bean
    public FilterRegistrationBean<CallContextFilter> filterCallContext() {
        return this.createFilterRegistration("CallContext", "/*", new CallContextFilter(), 2);
    }

    @Bean
    public FilterRegistrationBean<CorrelationFilter> filterCorrelation() {
        return this.createFilterRegistration("Correlation", "/*", new CorrelationFilter(), 1);
    }

    @Bean
    public FilterRegistrationBean<LanguageFilter> filterLanguage() {
        return this.createFilterRegistration("LanguageSelector", "/*", new LanguageFilter(), 4);
    }

    @Bean
    public SimpleUrlHandlerMapping handlerMapping() {
        SimpleUrlHandlerMapping mapping = new SimpleUrlHandlerMapping();
        mapping.setOrder(-2147483646);
        mapping.setUrlMap(Map.ofEntries(Map.entry("/ng/**", this.requestHandlerNg()), Map.entry("/bridge/**", this.requestHandlerBridge())));
        return mapping;
    }

    @Bean
    public ResourceHttpRequestHandler requestHandlerBridge() {
        return this.createAngularAppHttpRequestHandler("bridge", "ui/bridge");
    }

    @Bean
    public ResourceHttpRequestHandler requestHandlerNg() {
        return this.createAngularAppHttpRequestHandler("ng", "ui/ng");
    }
}

