/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.cloudsuite.gears.core.initializer;

import de.intarsys.spring.properties.PropertySourceResolver;
import de.intarsys.tools.application.ApplicationResolver;
import de.intarsys.tools.crypto.SecretResolver;
import de.intarsys.tools.expression.ActivityContextAwareResolver;
import de.intarsys.tools.expression.AliasResolver;
import de.intarsys.tools.expression.CountersResolver;
import de.intarsys.tools.expression.DynamicArgsResolver;
import de.intarsys.tools.expression.EntityResolver;
import de.intarsys.tools.expression.EnvironmentResolver;
import de.intarsys.tools.expression.ExpressionEvaluator;
import de.intarsys.tools.expression.IStringEvaluator;
import de.intarsys.tools.expression.IdentifiersResolver;
import de.intarsys.tools.expression.MapResolver;
import de.intarsys.tools.expression.Mode;
import de.intarsys.tools.expression.MutableResolver;
import de.intarsys.tools.expression.NLSMessageResolver;
import de.intarsys.tools.expression.NLSStringResolver;
import de.intarsys.tools.expression.RestrictedStringEvaluator;
import de.intarsys.tools.expression.ScopedResolver;
import de.intarsys.tools.expression.SystemResolver;
import de.intarsys.tools.expression.TaggedStringEvaluator;
import de.intarsys.tools.expression.TemplateEvaluator;
import de.intarsys.tools.expression.ThreadContextAwareResolver;
import de.intarsys.tools.expression.TimeResolver;
import de.intarsys.tools.lang.Aliases;
import java.util.regex.Pattern;
import java.util.stream.Stream;
import org.springframework.context.ApplicationContextInitializer;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.core.env.Environment;

public class EvaluatorInitializer
implements ApplicationContextInitializer<ConfigurableApplicationContext> {
    private static final String ALLOW_PATTERN_PROPERTY = "gears.core.expressions.untrusted.allow";
    private static final String BLOCK_PATTERN_PROPERTY = "gears.core.expressions.untrusted.block";

    private IStringEvaluator createResolver(IStringEvaluator ... resolvers) {
        ScopedResolver resolver = ScopedResolver.create((IStringEvaluator[])new IStringEvaluator[]{new DynamicArgsResolver(), new ThreadContextAwareResolver(), new ActivityContextAwareResolver()});
        Stream.of(resolvers).forEach(arg_0 -> ((ScopedResolver)resolver).addResolver(arg_0));
        return new MutableResolver((IStringEvaluator)new AliasResolver((IStringEvaluator)resolver, arg_0 -> ((Aliases)Aliases.get()).resolve(arg_0)));
    }

    private IStringEvaluator createTemplateEvaluator(IStringEvaluator resolver) {
        return TaggedStringEvaluator.decorateLenient((IStringEvaluator[])new IStringEvaluator[]{resolver});
    }

    private Pattern getPattern(ConfigurableApplicationContext applicationContext, String name) {
        String value = applicationContext.getEnvironment().getProperty(name);
        return value == null ? null : Pattern.compile(value);
    }

    public void initialize(ConfigurableApplicationContext applicationContext) {
        MapResolver unsafeNamespaces = MapResolver.createStrict().put("system", (Object)new SystemResolver()).put("environment", (Object)new EnvironmentResolver()).put("properties", (Object)new PropertySourceResolver((Environment)applicationContext.getEnvironment())).put("secret", (Object)new SecretResolver());
        MapResolver safeNamespaces = MapResolver.createStrict().put("app", (Object)new ApplicationResolver()).put("counters", (Object)new CountersResolver()).put("entity", (Object)new EntityResolver()).put("identifiers", (Object)new IdentifiersResolver()).put("nlsstr", (Object)new NLSStringResolver(applicationContext.getClassLoader())).put("nlsmsg", (Object)new NLSMessageResolver(applicationContext.getClassLoader())).put("time", (Object)new TimeResolver());
        IStringEvaluator trustedResolver = this.createResolver(new IStringEvaluator[]{safeNamespaces, unsafeNamespaces});
        ExpressionEvaluator.set((Mode)Mode.TRUSTED, (IStringEvaluator)trustedResolver);
        TemplateEvaluator.set((Mode)Mode.TRUSTED, (IStringEvaluator)this.createTemplateEvaluator(trustedResolver));
        Pattern allowPattern = this.getPattern(applicationContext, ALLOW_PATTERN_PROPERTY);
        Pattern blockPattern = this.getPattern(applicationContext, BLOCK_PATTERN_PROPERTY);
        IStringEvaluator untrustedResolver = allowPattern == null && blockPattern == null ? this.createResolver(new IStringEvaluator[]{safeNamespaces}) : this.createResolver(new IStringEvaluator[]{safeNamespaces, new RestrictedStringEvaluator((IStringEvaluator)unsafeNamespaces, allowPattern, blockPattern)});
        ExpressionEvaluator.set((Mode)Mode.UNTRUSTED, (IStringEvaluator)untrustedResolver);
        TemplateEvaluator.set((Mode)Mode.UNTRUSTED, (IStringEvaluator)this.createTemplateEvaluator(untrustedResolver));
    }
}

