/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.cloudsuite.gears.core.initializer;

import de.intarsys.tools.application.ApplicationComponent;
import de.intarsys.tools.file.PathTools;
import de.intarsys.tools.message.BasicMessageBundleFactory;
import de.intarsys.tools.message.IMessageBundleFactory;
import de.intarsys.tools.message.MessageTools;
import de.intarsys.tools.message.NlsContextMessageBundleFactory;
import de.intarsys.tools.nls.INlsContext;
import de.intarsys.tools.nls.ThreadNlsContext;
import de.intarsys.tools.servicelocator.ServiceLocator;
import de.intarsys.tools.string.StringTools;
import java.io.IOException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.ApplicationContextInitializer;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.core.annotation.Order;

@Order(value=-98)
public class NlsInitializer
implements ApplicationContextInitializer<ConfigurableApplicationContext> {
    public static final int PRECEDENCE = -98;
    private static final Logger Log = LoggerFactory.getLogger(NlsInitializer.class);

    public void initialize(ConfigurableApplicationContext applicationContext) {
        ThreadNlsContext nlsContext = new ThreadNlsContext();
        ServiceLocator.get().put(INlsContext.class, (Object)nlsContext);
        IMessageBundleFactory factory = null;
        String key = ApplicationComponent.get().prefixProperty("i18n.dir");
        String i18nDir = applicationContext.getEnvironment().getProperty(key);
        if (StringTools.isEmpty((String)i18nDir)) {
            key = ApplicationComponent.get().prefixProperty("config.shared");
            i18nDir = PathTools.join((String[])new String[]{applicationContext.getEnvironment().getProperty(key), "i18n"});
        }
        try {
            ClassLoader classLoader = BasicMessageBundleFactory.createClassLoader(null, (String)i18nDir);
            if (classLoader != null) {
                NlsContextMessageBundleFactory directoryFactory = new NlsContextMessageBundleFactory();
                directoryFactory.setClassloader(classLoader);
                factory = MessageTools.combineFactory((IMessageBundleFactory)factory, (IMessageBundleFactory)directoryFactory);
                Log.info("i18n resources loaded from {}", (Object)i18nDir);
            } else {
                Log.info("i18n no local resources at ({})", (Object)i18nDir);
            }
        }
        catch (IOException e) {
            Log.warn("i18n resources lookup failed for {}", (Object)i18nDir, (Object)e);
        }
        factory = MessageTools.combineFactory(factory, (IMessageBundleFactory)new NlsContextMessageBundleFactory());
        ServiceLocator.get().put(IMessageBundleFactory.class, (Object)factory);
    }
}

