/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.cloudsuite.gears.core.initializer;

import de.intarsys.tools.application.ApplicationComponent;
import de.intarsys.tools.environment.file.IFileEnvironment;
import de.intarsys.tools.environment.file.StandardFileEnvironment;
import de.intarsys.tools.file.FileTools;
import de.intarsys.tools.string.StringTools;
import java.io.File;
import java.io.IOException;
import org.springframework.core.env.ConfigurableEnvironment;

public class SpringServerFileEnvironment
implements IFileEnvironment {
    private static final String PROP_TEMP_DIR = "temp.dir";
    private static final String PROP_PROFILE_DIR = "profile.dir";
    private static final String PROP_DATA_DIR = "data.dir";
    private static final String PROP_BASE_DIR = "base.dir";
    public static final String PROP_USER_DIR = "user.dir";
    public static final String PROP_USER_HOME = "user.home";
    private final ConfigurableEnvironment environment;
    private final IFileEnvironment defaultEnvironment = new StandardFileEnvironment();
    private File baseDir;
    private File profileDir;
    private File dataDir;
    private File tempDir;
    private File workingDir;

    public SpringServerFileEnvironment(ConfigurableEnvironment environment) {
        this.environment = environment;
    }

    protected File createBaseDir() {
        String propName = ApplicationComponent.get().prefixProperty(PROP_BASE_DIR);
        String dirName = this.environment.getProperty(propName);
        if (StringTools.isEmpty((String)dirName)) {
            return this.defaultEnvironment.getBaseDir();
        }
        return new File(dirName);
    }

    protected File createDataDir() {
        String propName = ApplicationComponent.get().prefixProperty(PROP_DATA_DIR);
        String dirName = this.environment.getProperty(propName);
        if (StringTools.isEmpty((String)dirName)) {
            return this.getProfileDir();
        }
        return new File(dirName);
    }

    protected File createProfileDir() {
        String dirName = null;
        String propName = ApplicationComponent.get().prefixProperty(PROP_PROFILE_DIR);
        dirName = this.environment.getProperty(propName);
        if (StringTools.isEmpty((String)dirName)) {
            return this.defaultEnvironment.getProfileDir();
        }
        File dir = new File(dirName = FileTools.trimPath((String)dirName));
        if (dir.exists()) {
            if (!dir.isDirectory()) {
                dir = new File(this.environment.getProperty(PROP_USER_HOME));
            }
        } else {
            try {
                FileTools.mkdirs((File)dir);
            }
            catch (IOException e) {
                dir = new File(this.environment.getProperty(PROP_USER_HOME));
            }
        }
        return dir;
    }

    protected File createTempDir() {
        String propName = ApplicationComponent.get().prefixProperty(PROP_TEMP_DIR);
        String dirName = this.environment.getProperty(propName);
        if (StringTools.isEmpty((String)dirName)) {
            return this.defaultEnvironment.getTempDir();
        }
        return new File(dirName);
    }

    public File getBaseDir() {
        if (this.baseDir == null) {
            this.baseDir = this.createBaseDir();
        }
        return this.baseDir;
    }

    public File getDataDir() {
        if (this.dataDir == null) {
            this.dataDir = this.createDataDir();
        }
        return this.dataDir;
    }

    public File getProfileDir() {
        if (this.profileDir == null) {
            this.profileDir = this.createProfileDir();
        }
        return this.profileDir;
    }

    public File getTempDir() {
        if (this.tempDir == null) {
            this.tempDir = this.createTempDir();
        }
        return this.tempDir;
    }

    public File getWorkingDir() {
        if (this.workingDir == null) {
            this.workingDir = this.getBaseDir();
        }
        return this.workingDir;
    }
}

