/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.cloudsuite.gears.core.service.explorer.impl;

import de.intarsys.aaa.authenticate.api.AuthenticationProvider;
import de.intarsys.aaa.authenticate.api.IAuthentication;
import de.intarsys.cloudsuite.flow.common.CommonFlow;
import de.intarsys.cloudsuite.flow.common.FlowConfiguration;
import de.intarsys.cloudsuite.gears.action.IServerAction;
import de.intarsys.cloudsuite.gears.core.service.common.api.FlowOptions;
import de.intarsys.cloudsuite.gears.core.service.common.api.IOptionSupport;
import de.intarsys.cloudsuite.gears.core.service.common.api.RequestFlowCreate;
import de.intarsys.cloudsuite.gears.core.service.common.api.TransportDocument;
import de.intarsys.cloudsuite.gears.core.service.common.api.TransportItem;
import de.intarsys.cloudsuite.gears.core.service.common.impl.RepositoryDocumentState;
import de.intarsys.cloudsuite.gears.core.service.common.impl.RequestExecute;
import de.intarsys.cloudsuite.gears.core.service.common.impl.ResponseExecute;
import de.intarsys.cloudsuite.gears.core.service.common.impl.SvcInteractive;
import de.intarsys.cloudsuite.gears.core.service.explorer.api.RequestExplorerCreate;
import de.intarsys.cloudsuite.gears.core.service.explorer.api.ResponseExplorerCreate;
import de.intarsys.cloudsuite.gears.core.service.explorer.api.ResultExplorer;
import de.intarsys.cloudsuite.gears.core.service.explorer.impl.FlowExplorer;
import de.intarsys.cloudsuite.gears.core.service.explorer.impl.FlowExplorerConfiguration;
import de.intarsys.cloudsuite.gears.core.service.explorer.impl.RequestDownload;
import de.intarsys.cloudsuite.gears.core.service.explorer.impl.RequestGetParameters;
import de.intarsys.cloudsuite.gears.core.service.explorer.impl.ResponseGetParameters;
import de.intarsys.cloudsuite.gears.flow.common.CoreFlow;
import de.intarsys.cloudsuite.gears.repository.impl.RepositoryItem;
import de.intarsys.cloudsuite.gears.repository.impl.RestrictedIdentificationProvider;
import de.intarsys.cloudsuite.tools.common.ArgsTransformer;
import de.intarsys.conversation.service.client.api.ConversationalResponse;
import de.intarsys.conversation.service.client.api.IntegrationOptions;
import de.intarsys.conversation.service.component.api.Outcome;
import de.intarsys.tools.collection.ListTools;
import de.intarsys.tools.concurrent.SynchronousExecutorService;
import de.intarsys.tools.conversation.ConversationRegistry;
import de.intarsys.tools.conversation.Conversational;
import de.intarsys.tools.conversation.IConversation;
import de.intarsys.tools.conversation.IReplyStage;
import de.intarsys.tools.conversation.impl.Conversation;
import de.intarsys.tools.conversation.impl.HttpRedirectStage;
import de.intarsys.tools.conversation.impl.MonitorConversation;
import de.intarsys.tools.conversation.service.impl.ConversationServiceTools;
import de.intarsys.tools.exception.EncodedException;
import de.intarsys.tools.exception.ExceptionTools;
import de.intarsys.tools.expression.IStringEvaluator;
import de.intarsys.tools.expression.Mode;
import de.intarsys.tools.expression.TemplateEvaluator;
import de.intarsys.tools.file.PathTools;
import de.intarsys.tools.function.Throwing;
import de.intarsys.tools.functor.ArgTools;
import de.intarsys.tools.functor.Args;
import de.intarsys.tools.functor.IArgs;
import de.intarsys.tools.jaxrs.RequestContext;
import de.intarsys.tools.jaxrs.ServiceImplementor;
import de.intarsys.tools.jaxrs.Stateful;
import de.intarsys.tools.loadbalance.LoadBalanceContext;
import de.intarsys.tools.loadbalance.LoadBalanced;
import de.intarsys.tools.locator.ILocator;
import de.intarsys.tools.logging.slf4j.Slf4jTools;
import de.intarsys.tools.stream.StreamTools;
import de.intarsys.tools.string.StringTools;
import de.intarsys.tools.zones.IZone;
import de.intarsys.widget.common.WidgetExpander;
import de.intarsys.widget.model.ActionSpec;
import de.intarsys.widget.model.WidgetDefinition;
import io.swagger.v3.oas.annotations.Operation;
import jakarta.ws.rs.Consumes;
import jakarta.ws.rs.POST;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.WebApplicationException;
import jakarta.ws.rs.core.Response;
import jakarta.ws.rs.core.StreamingOutput;
import jakarta.ws.rs.core.UriBuilder;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Path(value="/v1/flow/explorer")
@Component
@ServiceImplementor
public class SvcExplorer
extends SvcInteractive<ResultExplorer, FlowExplorerConfiguration> {
    public static final String PARAM_STATE = "state";
    public static final String PRESENTATION_FOLDER = "ng";
    public static final String PRESENTATION_PATH = "explorer";
    public static final String DOWNLOAD_FOLDER_NAME = "folder.zip";
    public static final String CONV_NAME = "explorer";
    private static final Logger Log = LoggerFactory.getLogger(SvcExplorer.class);

    @Conversational
    @LoadBalanced
    @Stateful(role=Stateful.Role.Producer)
    @POST
    @Path(value="/create")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @Operation
    public ResponseExplorerCreate create(RequestExplorerCreate request) {
        FlowExplorer flow = this.createFlow(request);
        IZone zone = this.createZone((CoreFlow)flow);
        try {
            this.validateRequest(request);
            IAuthentication authentication = AuthenticationProvider.get().getAuthentication();
            flow.setAuthenticationContext(authentication);
            flow.setLabel(request.getLabel());
            flow.setOptions(request.getOptions());
            flow.setArgs(request.getArgs());
            flow.setRepoDocStates(this.createRepoDocStates(request));
            flow.addAdditionalResolver((IStringEvaluator)this.createResolver((CommonFlow)flow));
            zone.wrap(f -> {
                flow.setConfiguration((FlowConfiguration)this.getConfiguration((RequestFlowCreate)request));
                this.createEncryption(flow);
                IntegrationOptions integrationOptions = FlowOptions.getIntegrationOptions((IOptionSupport)flow);
                ConversationServiceTools.setRootConversation(flow.getConversation());
                ConversationServiceTools.setIntegrationOptions(flow.getConversation(), (IntegrationOptions)integrationOptions);
                flow.getConversation().monitor(zone.wrap((Throwing.Specific.Supplier)((Throwing.Supplier)() -> this.createMainConversation(flow))));
            }).accept(flow);
        }
        catch (Exception e) {
            flow.getConversation().completeExceptionally((Throwable)e);
        }
        flow.getConversation().forwardTermination();
        this.getConversationRegistry().publish(flow.getConversation());
        ResponseExplorerCreate response = new ResponseExplorerCreate();
        this.finishRequest((ConversationalResponse)response, flow.getConversation());
        return response;
    }

    protected FlowExplorerConfiguration createDefaultConfiguration() {
        FlowExplorerConfiguration config = new FlowExplorerConfiguration();
        config.setId("default");
        config.setWidgets(new ArrayList());
        return config;
    }

    protected FlowExplorer createFlow(RequestExplorerCreate request) {
        FlowExplorer flow = new FlowExplorer(this.getRepository());
        ExecutorService tmpExecutor = FlowOptions.isAsynch((IOptionSupport)request) ? executor : new SynchronousExecutorService();
        MonitorConversation r = new MonitorConversation("monitor", tmpExecutor);
        r.exceptionally(ex -> {
            flow.dispose();
            throw Conversation.rethrowable((Throwable)ex);
        });
        flow.setConversation((IConversation)r);
        Slf4jTools.addCorrelation(null, (String)flow.getId());
        return flow;
    }

    protected IConversation<ResultExplorer> createMainConversation(FlowExplorer flow) {
        UriBuilder uriBuilder;
        this.runAssertions((CommonFlow)flow, "before");
        if (flow.getConfiguration().getArguments() != null) {
            ArgsTransformer transformer = new ArgsTransformer(flow.getConfiguration().getArguments(), true);
            flow.setArgs(transformer.apply(flow.getArgs()));
        }
        ArgTools.expandDeep((IArgs)flow.getArgs(), (IStringEvaluator)TemplateEvaluator.get((Mode)Mode.UNTRUSTED));
        this.runAssertions((CommonFlow)flow, "merged");
        this.configurationTweak(flow.getConfiguration(), flow.getArgs());
        flow.getConfiguration().expand(TemplateEvaluator.get((Mode)Mode.UNTRUSTED));
        Conversation conversation = new Conversation("explorer");
        UriBuilder uriBuilderServer = RequestContext.get().getUriBuilderContext();
        String debugUrlClient = (String)flow.getOption("debug.urlClient");
        if (StringTools.isEmpty((String)debugUrlClient)) {
            uriBuilder = uriBuilderServer;
            uriBuilder.path(PRESENTATION_FOLDER);
        } else {
            uriBuilder = UriBuilder.fromUri((String)debugUrlClient);
            LoadBalanceContext.get().processUri(uriBuilder);
            uriBuilder.queryParam("urlServer", new Object[]{uriBuilderServer.build(new Object[0]).toString()});
        }
        uriBuilder.path("explorer");
        uriBuilder.queryParam(PARAM_STATE, new Object[]{conversation.getHandle()});
        String lang = FlowOptions.getLang((IOptionSupport)flow);
        if (!StringTools.isEmpty((String)lang)) {
            uriBuilder.replaceQueryParam("lang", new Object[]{lang});
        }
        HttpRedirectStage stage = new HttpRedirectStage(uriBuilder.build(new Object[0]), false, true);
        stage.onAck(outcome -> {
            try {
                this.runInContext((CoreFlow)flow, f -> {
                    try {
                        Outcome tempOutcome = Outcome.create((Object)outcome);
                        if (tempOutcome != null) {
                            if (tempOutcome.isOk()) {
                                ResultExplorer result = new ResultExplorer();
                                result.setDocumentNames(flow.getRepoDocStates().stream().map(repoDocState -> repoDocState.getRepoDoc().getLocator().getName()).toList());
                                result.setArtifacts(flow.getArtifacts());
                                conversation.complete((Object)result);
                            } else if (tempOutcome.isFail()) {
                                conversation.completeExceptionally((Throwable)new EncodedException("unknown", "unknown"));
                            } else if (tempOutcome.isCancel()) {
                                conversation.cancel(false);
                            }
                        }
                    }
                    catch (Exception e) {
                        conversation.completeExceptionally((Throwable)new EncodedException("unknown", "unknown"));
                    }
                    return null;
                });
            }
            catch (Exception e) {
                RuntimeException ex = new RuntimeException("unexpected exception", e);
                conversation.completeExceptionally((Throwable)ex);
            }
        });
        conversation.setReplyStage((IReplyStage)stage);
        ConversationRegistry.publishForLifetime((IConversation)conversation);
        return conversation;
    }

    protected StreamingOutput createStreamDocument(final RepositoryItem repoItem) {
        final Object ri = RestrictedIdentificationProvider.getRestrictedIdentification();
        StreamingOutput stream = new StreamingOutput(){

            public void write(OutputStream os) throws IOException, WebApplicationException {
                InputStream is = null;
                try {
                    RestrictedIdentificationProvider.enter((Object)ri);
                    ILocator locator = repoItem.getLocator();
                    is = locator.getInputStream();
                    StreamTools.copy((InputStream)is, (OutputStream)os);
                }
                catch (Exception e) {
                    try {
                        throw new IOException(e);
                    }
                    catch (Throwable throwable) {
                        RestrictedIdentificationProvider.leave();
                        StreamTools.close(is);
                        throw throwable;
                    }
                }
                RestrictedIdentificationProvider.leave();
                StreamTools.close((Closeable)is);
            }
        };
        return stream;
    }

    protected StreamingOutput createStreamDocuments(final FlowExplorer flow) {
        final Object ri = RestrictedIdentificationProvider.getRestrictedIdentification();
        StreamingOutput stream = new StreamingOutput(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public void write(OutputStream os) throws IOException, WebApplicationException {
                try {
                    RestrictedIdentificationProvider.enter((Object)ri);
                    try (ZipOutputStream zos = new ZipOutputStream(os);){
                        InputStream is = null;
                        for (RepositoryDocumentState repoItemState : flow.getRepoDocStates()) {
                            try {
                                zos.putNextEntry(new ZipEntry(repoItemState.getRepoDoc().getMetadata().getName()));
                                ILocator locator = repoItemState.getRepoDoc().getLocator();
                                is = locator.getInputStream();
                                StreamTools.copy((InputStream)is, (OutputStream)zos);
                                zos.closeEntry();
                            }
                            catch (Throwable throwable) {
                                StreamTools.close(is);
                                throw throwable;
                                return;
                            }
                            StreamTools.close((Closeable)is);
                        }
                    }
                }
                catch (Exception e) {
                    throw new IOException(e);
                }
                finally {
                    RestrictedIdentificationProvider.leave();
                }
            }
        };
        return stream;
    }

    @Conversational
    @LoadBalanced
    @Stateful(role=Stateful.Role.Consumer)
    @POST
    @Path(value="/download")
    @Consumes(value={"application/json"})
    @Operation(hidden=true, operationId="explorerDownload")
    public Response download(RequestDownload request) throws Exception {
        IConversation conversation = this.lookupConversation(request.getConversationHandle());
        FlowExplorer flow = (FlowExplorer)CommonFlow.getFlow((IConversation)conversation, FlowExplorer.class);
        return (Response)this.runInContext((CoreFlow)flow, f -> {
            String filename;
            StreamingOutput stream;
            if (request.getDocument() == null) {
                stream = this.createStreamDocuments(flow);
                filename = PathTools.getName((String)DOWNLOAD_FOLDER_NAME);
            } else {
                RepositoryDocumentState itemState = flow.resolveRepoDocState(request.getDocument());
                stream = this.createStreamDocument((RepositoryItem)itemState.getRepoDoc());
                filename = PathTools.getName((String)itemState.getRepoDoc().getMetadata().getName());
            }
            return Response.ok((Object)stream).header("Content-type", (Object)"application/octet-stream").header("Content-Disposition", (Object)("attachment; filename=\"" + filename + "\"")).build();
        });
    }

    @Conversational
    @LoadBalanced
    @Stateful(role=Stateful.Role.Consumer)
    @POST
    @Path(value="/execute")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @Operation(hidden=true, operationId="explorerExecute")
    public ResponseExecute execute(RequestExecute request) throws Exception {
        IConversation conversation = this.lookupConversation(request.getConversationHandle());
        FlowExplorer flow = (FlowExplorer)CommonFlow.getFlow((IConversation)conversation, FlowExplorer.class);
        return (ResponseExecute)this.runInContext((CoreFlow)flow, f -> {
            IConversation actionConversation;
            try {
                IServerAction action = this.createServerAction((CommonFlow)flow, request.getAction());
                IArgs args = request.getArgs();
                actionConversation = action.invoke((CoreFlow)flow, (IArgs)(args == null ? Args.create() : args));
            }
            catch (Exception e) {
                actionConversation = Conversation.failed((Throwable)e);
                Log.warn("conversation {} execute failed ({})", new Object[]{conversation, ExceptionTools.getMessage((Throwable)e), e});
            }
            ResponseExecute response = new ResponseExecute();
            this.finishRequest((ConversationalResponse)response, actionConversation);
            return response;
        });
    }

    protected Class<FlowExplorerConfiguration> getConfigurationType() {
        return FlowExplorerConfiguration.class;
    }

    @Conversational
    @LoadBalanced
    @Stateful(role=Stateful.Role.Consumer)
    @POST
    @Path(value="/getParameters")
    @Produces(value={"application/json"})
    @Operation(hidden=true, operationId="explorerParameters")
    public ResponseGetParameters getParameters(RequestGetParameters request) throws Exception {
        IConversation conversation = this.lookupConversation(request.getConversationHandle());
        FlowExplorer flow = (FlowExplorer)CommonFlow.getFlow((IConversation)conversation, FlowExplorer.class);
        return (ResponseGetParameters)this.runInContext((CoreFlow)flow, f -> {
            ArrayList<TransportItem> transportList = new ArrayList<TransportItem>();
            for (RepositoryDocumentState repoItemState : flow.getRepoDocStates()) {
                Object tmpViewed;
                TransportDocument transportDoc = new TransportDocument();
                transportDoc.setHandle(repoItemState.getRepoDoc().getLocator());
                transportDoc.addProperties(repoItemState.getRepoDoc().getProperties().getProperties());
                Object tmpSigned = repoItemState.getAttribute((Object)"cs.signed");
                if (tmpSigned != null) {
                    transportDoc.setProperty("cs.signed", tmpSigned);
                }
                if ((tmpViewed = repoItemState.getAttribute((Object)"cs.viewed")) != null) {
                    transportDoc.setProperty("cs.viewed", tmpViewed);
                }
                transportList.add((TransportItem)transportDoc);
            }
            ResponseGetParameters response = new ResponseGetParameters();
            response.setLabel(flow.getLabel());
            response.setDocuments(transportList);
            List tempWidgets = ListTools.copyDeep((List)flow.getConfiguration().getWidgets());
            WidgetExpander.process((List)tempWidgets);
            response.setWidgets(tempWidgets);
            response.setInvocations(flow.getInvocations());
            return response;
        });
    }

    protected void validateRequest(RequestExplorerCreate request) {
        if (request == null) {
            throw new IllegalArgumentException("request can not be empty");
        }
    }

    protected void widgetDefinitionsCreateService(List<WidgetDefinition> widgetDefinitions) {
        WidgetDefinition child;
        if (!this.widgetDefinitionHasChildren(widgetDefinitions, "de.intarsys.widget.toolbar.center")) {
            child = WidgetDefinition.builder().parentName("de.intarsys.widget.toolbar.center").type("Label").label("${flow.label:!\"-\"}").build();
            widgetDefinitions.add(child);
        }
        if (!this.widgetDefinitionHasChildren(widgetDefinitions, "de.intarsys.widget.toolbar.right")) {
            child = WidgetDefinition.builder().parentName("de.intarsys.widget.toolbar.right").on("select", (Object)ActionSpec.build((String)"Ok", null)).build();
            widgetDefinitions.add(child);
        }
    }
}

