/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.cloudsuite.gears.core.service.nls.impl;

import de.intarsys.tools.functor.ArgTools;
import de.intarsys.tools.functor.Args;
import de.intarsys.tools.functor.IArgs;
import de.intarsys.tools.jaxrs.ServiceImplementor;
import de.intarsys.tools.message.IMessageBundle;
import de.intarsys.tools.message.MessageBundleFactory;
import de.intarsys.tools.nls.NlsContext;
import de.intarsys.tools.reflect.ClassLoaderTools;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.PathParam;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.QueryParam;
import java.util.Locale;
import org.springframework.stereotype.Component;

@Path(value="/v1/nls")
@Component
@ServiceImplementor
public class SvcNLS {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @GET
    @Path(value="/messages/{language}")
    @Produces(value={"application/json"})
    public IArgs getNLS(@PathParam(value="language") String language, @QueryParam(value="baseName") String baseName) {
        Locale locale = Locale.forLanguageTag(language);
        NlsContext.get().pushLocale(locale);
        try {
            Args messages = Args.create();
            String name = baseName == null ? "" : baseName;
            ClassLoader classLoader = ClassLoaderTools.defaultClassLoader();
            IMessageBundle bundle = MessageBundleFactory.get().getMessageBundle(name, classLoader);
            for (String code : bundle.getCodes()) {
                ArgTools.putPath((IArgs)messages, (String)code, (Object)bundle.getString(code, new Object[0]));
            }
            Args args = messages;
            return args;
        }
        finally {
            NlsContext.get().popLocale();
        }
    }
}

