/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.cloudsuite.gears.core.service.signer.impl;

import de.intarsys.aaa.authenticate.api.AuthenticationProvider;
import de.intarsys.aaa.authenticate.api.IAuthentication;
import de.intarsys.cloudsuite.flow.common.CommonFlow;
import de.intarsys.cloudsuite.gears.core.service.common.api.DtoValidationData;
import de.intarsys.cloudsuite.gears.core.service.common.api.FlowOptions;
import de.intarsys.cloudsuite.gears.core.service.common.api.IOptionSupport;
import de.intarsys.cloudsuite.gears.core.service.common.api.RequestFlowCreate;
import de.intarsys.cloudsuite.gears.core.service.common.api.TransportDocument;
import de.intarsys.cloudsuite.gears.core.service.common.impl.RepositoryDocumentState;
import de.intarsys.cloudsuite.gears.core.service.common.impl.SvcRepositoryBased;
import de.intarsys.cloudsuite.gears.core.service.signer.api.RequestSignerCreate;
import de.intarsys.cloudsuite.gears.core.service.signer.api.ResponseSignerCreate;
import de.intarsys.cloudsuite.gears.core.service.signer.api.ResultSigner;
import de.intarsys.cloudsuite.gears.core.service.signer.impl.FlowSigner;
import de.intarsys.cloudsuite.gears.core.service.signer.impl.FlowSignerConfiguration;
import de.intarsys.cloudsuite.gears.flow.common.CoreFlow;
import de.intarsys.cloudsuite.gears.security.app.GenericSignerSpecTransformer;
import de.intarsys.cloudsuite.gears.security.app.ISignerSpecTransformer;
import de.intarsys.cloudsuite.tools.common.ArgsTransformer;
import de.intarsys.conversation.service.client.api.ConversationalResponse;
import de.intarsys.conversation.service.client.api.IntegrationOptions;
import de.intarsys.security.certificate.IX509Certificate;
import de.intarsys.security.crl.IX509CRL;
import de.intarsys.security.method.cms.validation.ResultValidationDataAppender;
import de.intarsys.security.ocsp.IOCSPResponse;
import de.intarsys.security.processor.signature.MultiSignerFactory;
import de.intarsys.security.signature.ISignatureContainer;
import de.intarsys.security.validation.IExtendedValidationData;
import de.intarsys.tools.concurrent.SynchronousExecutorService;
import de.intarsys.tools.conversation.Conversational;
import de.intarsys.tools.conversation.IConversation;
import de.intarsys.tools.conversation.IConversationSupport;
import de.intarsys.tools.conversation.impl.Conversation;
import de.intarsys.tools.conversation.impl.MonitorConversation;
import de.intarsys.tools.conversation.service.impl.ConversationServiceTools;
import de.intarsys.tools.expression.IStringEvaluator;
import de.intarsys.tools.expression.Mode;
import de.intarsys.tools.expression.TemplateEvaluator;
import de.intarsys.tools.factory.InstanceSpec;
import de.intarsys.tools.function.OnError;
import de.intarsys.tools.function.Throwing;
import de.intarsys.tools.functor.ArgTools;
import de.intarsys.tools.functor.IArgs;
import de.intarsys.tools.jaxrs.ServiceImplementor;
import de.intarsys.tools.jaxrs.Stateful;
import de.intarsys.tools.loadbalance.LoadBalanced;
import de.intarsys.tools.locator.ILocator;
import de.intarsys.tools.logging.slf4j.Slf4jTools;
import de.intarsys.tools.reflect.ObjectCreationException;
import de.intarsys.tools.zones.IZone;
import io.swagger.v3.oas.annotations.Operation;
import jakarta.ws.rs.Consumes;
import jakarta.ws.rs.POST;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.Produces;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ExecutorService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Path(value="/v1/flow/signer")
@Component
@ServiceImplementor
public class SvcSigner
extends SvcRepositoryBased<ResultSigner, FlowSignerConfiguration> {
    public static final String SERVICE_PATH = "/v1/flow/signer/create";
    public static final String ARG_DOCUMENTS = "documents";
    public static final String PROP_SIGNED = "cs.signed";
    private static final String PROP_VALIDATIONDATA = "validationData";
    private static final Logger Log = LoggerFactory.getLogger(SvcSigner.class);

    @LoadBalanced
    @Conversational
    @Stateful(role=Stateful.Role.Producer)
    @POST
    @Path(value="/create")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @Operation
    public ResponseSignerCreate create(RequestSignerCreate request) {
        FlowSigner flow = this.createFlow(request);
        IZone zone = this.createZone((CoreFlow)flow);
        try {
            this.validateRequest(request);
            IAuthentication authentication = AuthenticationProvider.get().getAuthentication();
            flow.setAuthenticationContext(authentication);
            flow.setLabel(request.getLabel());
            flow.setOptions(request.getOptions());
            flow.setArgs(request.getArgs());
            flow.setRepoDocStates(this.createRepoDocStates(request));
            flow.addAdditionalResolver((IStringEvaluator)this.createResolver((CommonFlow)flow));
            zone.wrap(f -> {
                flow.setConfiguration(this.getConfiguration((RequestFlowCreate)request));
                this.createEncryption(flow);
                IntegrationOptions integrationOptions = FlowOptions.getIntegrationOptions((IOptionSupport)flow);
                ConversationServiceTools.setRootConversation(flow.getConversation());
                ConversationServiceTools.setIntegrationOptions(flow.getConversation(), (IntegrationOptions)integrationOptions);
                flow.getConversation().monitor(zone.wrap((Throwing.Specific.Supplier)((Throwing.Supplier)() -> this.createMainConversation(flow))));
            }).accept(flow);
        }
        catch (Exception e) {
            flow.getConversation().completeExceptionally((Throwable)e);
        }
        flow.getConversation().forwardTermination();
        this.getConversationRegistry().publish(flow.getConversation());
        ResponseSignerCreate response = new ResponseSignerCreate();
        this.finishRequest((ConversationalResponse)response, flow.getConversation());
        return response;
    }

    protected FlowSignerConfiguration createDefaultConfiguration() {
        FlowSignerConfiguration config = new FlowSignerConfiguration();
        config.setId("default");
        GenericSignerSpecTransformer transformer = new GenericSignerSpecTransformer();
        config.setSignerSpecTransformer((ISignerSpecTransformer)transformer);
        return config;
    }

    protected FlowSigner createFlow(RequestSignerCreate request) {
        FlowSigner flow = new FlowSigner(this.getRepository());
        ExecutorService tmpExecutor = FlowOptions.isAsynch((IOptionSupport)request) ? executor : new SynchronousExecutorService();
        MonitorConversation r = new MonitorConversation("monitor", tmpExecutor);
        r.exceptionally(ex -> {
            flow.dispose();
            throw Conversation.rethrowable((Throwable)ex);
        });
        flow.setConversation((IConversation)r);
        Slf4jTools.addCorrelation(null, (String)flow.getId());
        return flow;
    }

    protected IConversation<ResultSigner> createMainConversation(FlowSigner flow) {
        this.runAssertions((CommonFlow)flow, "before");
        if (!FlowOptions.isInternalCall((IOptionSupport)flow)) {
            SvcSigner.authorizeArgs((String)SERVICE_PATH, (IArgs)flow.getArgs());
        }
        if (flow.getConfiguration().getArguments() != null) {
            ArgsTransformer transformer = new ArgsTransformer(flow.getConfiguration().getArguments(), true);
            flow.setArgs(transformer.apply(flow.getArgs()));
        }
        List<ILocator> locators = flow.getRepoDocStates().stream().map(repoLink -> repoLink.getRepoDoc().getLocator()).toList();
        flow.getArgs().put(ARG_DOCUMENTS, locators);
        InstanceSpec requestSpec = this.createSignerSpec(flow.getArgs());
        requestSpec.getArgs().put("argsValidator", args -> SvcSigner.authorizeArgs((String)SERVICE_PATH, (IArgs)((IArgs)args)));
        if (flow.getConfiguration().getSignerSpecTransformer() != null) {
            try {
                requestSpec = flow.getConfiguration().getSignerSpecTransformer().decorate(requestSpec);
                flow.setArgs(requestSpec.getArgs());
            }
            catch (ObjectCreationException e) {
                return Conversation.failed((Throwable)e);
            }
        }
        ArgTools.expandDeep((IArgs)flow.getArgs(), (IStringEvaluator)TemplateEvaluator.get((Mode)Mode.UNTRUSTED));
        this.runAssertions((CommonFlow)flow, "merged");
        try {
            IConversationSupport processor = (IConversationSupport)requestSpec.createInstance();
            IConversation convSign = processor.getConversation();
            return convSign.thenApply(result -> (ResultSigner)this.runInContext((CoreFlow)flow, f -> this.transformResult(flow, (IArgs)result)));
        }
        catch (ObjectCreationException e) {
            return Conversation.failed((Throwable)e);
        }
    }

    protected InstanceSpec<Object> createSignerSpec(IArgs requestArgs) {
        return InstanceSpec.createFromFactory(Object.class, MultiSignerFactory.class, (Object)requestArgs);
    }

    protected Class<FlowSignerConfiguration> getConfigurationType() {
        return FlowSignerConfiguration.class;
    }

    protected ResultSigner transformResult(FlowSigner flow, IArgs signatureResult) {
        List signatureContainerList;
        ResultSigner transformedResult = new ResultSigner();
        transformedResult.setDocumentNames(flow.getRepoDocStates().stream().map(repoDocState -> repoDocState.getRepoDoc().getLocator().getName()).toList());
        ISignatureContainer signatureContainer = (ISignatureContainer)signatureResult.get("signature");
        if (signatureContainer != null) {
            TransportDocument signatureTransport = null;
            RepositoryDocumentState repoItemState = (RepositoryDocumentState)flow.getRepoDocStates().get(0);
            signatureTransport = this.transformResultDocument(flow, repoItemState, signatureContainer);
            transformedResult.setSignatures(new ArrayList());
            transformedResult.getSignatures().add(signatureTransport);
        }
        if ((signatureContainerList = (List)signatureResult.get("signatures")) != null) {
            ArrayList<TransportDocument> transformedDocList = new ArrayList<TransportDocument>();
            int index = 0;
            for (ISignatureContainer tmpSignatureContainer : signatureContainerList) {
                RepositoryDocumentState repoItemState = (RepositoryDocumentState)flow.getRepoDocStates().get(index);
                TransportDocument transformedDoc = this.transformResultDocument(flow, repoItemState, tmpSignatureContainer);
                transformedDocList.add(transformedDoc);
                ++index;
            }
            transformedResult.setSignatures(transformedDocList);
        }
        return transformedResult;
    }

    protected TransportDocument transformResultDocument(FlowSigner flow, RepositoryDocumentState repoDocState, ISignatureContainer signatureContainer) {
        IExtendedValidationData validationData;
        TransportDocument signatureTransport = new TransportDocument();
        signatureTransport.setProperty("signature.targetName", (Object)repoDocState.getRepoDoc().getLocator().getName());
        ILocator locator = signatureContainer.getLocator();
        if (repoDocState.isImported()) {
            signatureTransport.setContent(locator);
            if (signatureContainer.isDetached()) {
                flow.addToBeDisposed(() -> {
                    try {
                        locator.delete();
                    }
                    catch (IOException e) {
                        Log.warn("{} cannot delete resource", (Object)this, (Object)e);
                    }
                });
            }
        } else {
            signatureTransport.setHandle(locator);
        }
        if ((validationData = ResultValidationDataAppender.getValidationData((ISignatureContainer)signatureContainer)) != null) {
            DtoValidationData dtoValidationData = this.transformValidationData(validationData);
            signatureTransport.setProperty(PROP_VALIDATIONDATA, (Object)dtoValidationData);
        }
        return signatureTransport;
    }

    protected DtoValidationData transformValidationData(IExtendedValidationData validationData) {
        DtoValidationData dtoValidationData = new DtoValidationData();
        validationData.getOCSPResponses().map(OnError.rethrow(IOCSPResponse::getEncoded)).forEach(arg_0 -> ((DtoValidationData)dtoValidationData).addOcspResponse(arg_0));
        validationData.getCRLs().map(OnError.rethrow(IX509CRL::getEncoded)).forEach(arg_0 -> ((DtoValidationData)dtoValidationData).addCrl(arg_0));
        validationData.getCertificates().map(OnError.rethrow(IX509Certificate::getEncoded)).forEach(arg_0 -> ((DtoValidationData)dtoValidationData).addCertificate(arg_0));
        return dtoValidationData;
    }

    protected void validateRequest(RequestSignerCreate request) {
        if (request == null) {
            throw new IllegalArgumentException("request can not be null");
        }
        if (request.getDocuments() == null || request.getDocuments().isEmpty()) {
            throw new IllegalArgumentException("'documents' can not be empty");
        }
    }
}

