/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.cloudsuite.gears.core.service.timestamper.impl;

import de.intarsys.cloudsuite.gears.core.service.common.api.RequestFlowCreate;
import de.intarsys.cloudsuite.gears.core.service.common.api.TransportDocument;
import de.intarsys.cloudsuite.gears.core.service.common.impl.RepositoryDocumentState;
import de.intarsys.cloudsuite.gears.core.service.common.impl.SvcRepositoryBasedProcessor;
import de.intarsys.cloudsuite.gears.core.service.timestamper.api.RequestTimestamperCreate;
import de.intarsys.cloudsuite.gears.core.service.timestamper.api.ResponseTimestamperCreate;
import de.intarsys.cloudsuite.gears.core.service.timestamper.api.ResultTimestamper;
import de.intarsys.cloudsuite.gears.core.service.timestamper.impl.FlowTimestamper;
import de.intarsys.cloudsuite.gears.core.service.timestamper.impl.FlowTimestamperConfiguration;
import de.intarsys.cloudsuite.gears.repository.api.IRepository;
import de.intarsys.cloudsuite.tools.common.ArgsTransformer;
import de.intarsys.conversation.service.client.api.ConversationalResponse;
import de.intarsys.document.common.DocumentTools;
import de.intarsys.document.model.IDocument;
import de.intarsys.security.processor.timestamp.IDocumentTimestampCreator;
import de.intarsys.security.signature.ISignatureContainer;
import de.intarsys.tools.conversation.Conversational;
import de.intarsys.tools.conversation.IConversation;
import de.intarsys.tools.conversation.impl.Conversation;
import de.intarsys.tools.factory.InstanceSpec;
import de.intarsys.tools.functor.FunctorTools;
import de.intarsys.tools.functor.IArgs;
import de.intarsys.tools.jaxrs.ServiceImplementor;
import de.intarsys.tools.jaxrs.Stateful;
import de.intarsys.tools.loadbalance.LoadBalanced;
import de.intarsys.tools.locator.ILocator;
import io.swagger.v3.oas.annotations.Operation;
import jakarta.ws.rs.Consumes;
import jakarta.ws.rs.POST;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.Produces;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Path(value="/v1/flow/timestamper")
@Component
@ServiceImplementor
public class SvcTimestamper
extends SvcRepositoryBasedProcessor<ResultTimestamper, FlowTimestamperConfiguration, FlowTimestamper> {
    private static final String ARG_DOCUMENT = "document";
    private static final Logger Log = LoggerFactory.getLogger(SvcTimestamper.class);
    public static final String SERVICE_PATH = "/v1/flow/timestamper/create";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected IConversation<ResultTimestamper> basicProcess(FlowTimestamper flow) {
        if (flow.getConfiguration().getArguments() != null) {
            ArgsTransformer transformer = new ArgsTransformer(flow.getConfiguration().getArguments(), true);
            flow.setArgs(transformer.apply(flow.getArgs()));
        }
        List<ILocator> locators = flow.getRepoDocStates().stream().map(repoLink -> repoLink.getRepoDoc().getLocator()).toList();
        ArrayList signatureContainerList = new ArrayList();
        IDocument iDoc = null;
        for (ILocator locator : locators) {
            try {
                iDoc = DocumentTools.createDocument((Object)locator);
                InstanceSpec<?> requestSpec = this.createTimestamperSpec(flow.getArgs(), iDoc);
                ISignatureContainer signatureContainer = (ISignatureContainer)FunctorTools.perform(requestSpec);
                signatureContainerList.add(signatureContainer);
            }
            catch (Exception e) {
                IConversation iConversation = Conversation.failed((Throwable)e);
                return iConversation;
            }
            finally {
                if (iDoc == null) continue;
                iDoc.release(null);
            }
        }
        try {
            ResultTimestamper resultTimestamper = this.transformResult(flow, signatureContainerList);
            return Conversation.completed((Object)resultTimestamper);
        }
        catch (Exception e) {
            return Conversation.failed((Throwable)e);
        }
    }

    @Conversational
    @LoadBalanced
    @Stateful(role=Stateful.Role.Producer)
    @POST
    @Path(value="/create")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @Operation
    public ResponseTimestamperCreate create(RequestTimestamperCreate request) {
        IConversation conversation;
        try {
            this.validateRequest(request);
            conversation = this.doCreate((RequestFlowCreate)request, () -> this.createFlow(this.getRepository(), request), this::basicProcess);
        }
        catch (Exception e) {
            conversation = Conversation.failed((Throwable)e);
        }
        Log.debug("POST /flow/timestamper created {}", (Object)conversation);
        ResponseTimestamperCreate response = new ResponseTimestamperCreate();
        this.finishRequest((ConversationalResponse)response, conversation);
        return response;
    }

    protected FlowTimestamperConfiguration createDefaultConfiguration() {
        FlowTimestamperConfiguration config = new FlowTimestamperConfiguration();
        config.setId("default");
        return config;
    }

    protected FlowTimestamper createFlow(IRepository repository, RequestTimestamperCreate request) {
        return new FlowTimestamper(this.getRepository());
    }

    protected InstanceSpec<?> createTimestamperSpec(IArgs requestArgs, IDocument<?> iDoc) throws IOException {
        InstanceSpec spec = InstanceSpec.get((IArgs)requestArgs, (String)"documentTimestamper", IDocumentTimestampCreator.class, null);
        spec.getArgs().put(ARG_DOCUMENT, iDoc);
        return spec;
    }

    protected Class<FlowTimestamperConfiguration> getConfigurationType() {
        return FlowTimestamperConfiguration.class;
    }

    protected String getServicePath() {
        return SERVICE_PATH;
    }

    protected ResultTimestamper transformResult(FlowTimestamper flow, List<ISignatureContainer<?>> signatureContainerList) {
        ResultTimestamper transformedResult = new ResultTimestamper();
        transformedResult.setDocumentNames(flow.getRepoDocStates().stream().map(repoDocState -> repoDocState.getRepoDoc().getLocator().getName()).toList());
        if (signatureContainerList != null) {
            ArrayList<TransportDocument> transformedDocList = new ArrayList<TransportDocument>();
            int index = 0;
            for (ISignatureContainer<?> tmpSignatureContainer : signatureContainerList) {
                RepositoryDocumentState repoItemState = (RepositoryDocumentState)flow.getRepoDocStates().get(index);
                TransportDocument transformedDoc = this.transformResultDocument(flow, repoItemState, tmpSignatureContainer);
                transformedDocList.add(transformedDoc);
                ++index;
            }
            transformedResult.setDocumentTimestamps(transformedDocList);
        }
        return transformedResult;
    }

    protected TransportDocument transformResultDocument(FlowTimestamper flow, RepositoryDocumentState repoDocState, ISignatureContainer<?> signatureContainer) {
        TransportDocument signatureTransport = new TransportDocument();
        signatureTransport.setProperty("timestamp.targetName", (Object)repoDocState.getRepoDoc().getLocator().getName());
        ILocator locator = signatureContainer.getLocator();
        if (repoDocState.isImported()) {
            signatureTransport.setContent(locator);
            if (signatureContainer.isDetached()) {
                flow.addToBeDisposed(() -> {
                    try {
                        locator.delete();
                    }
                    catch (IOException e) {
                        Log.warn("{} cannot delete resource", (Object)this, (Object)e);
                    }
                });
            }
        } else {
            signatureTransport.setHandle(locator);
        }
        return signatureTransport;
    }

    protected void validateRequest(RequestTimestamperCreate request) {
        if (request == null) {
            throw new IllegalArgumentException("request can not be null");
        }
        if (request.getDocuments() == null || request.getDocuments().isEmpty()) {
            throw new IllegalArgumentException("'documents' can not be empty");
        }
    }
}

