/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.cloudsuite.gears.core.service.viewer.impl;

import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import de.intarsys.aaa.authenticate.api.AuthenticationProvider;
import de.intarsys.aaa.authenticate.api.IAuthentication;
import de.intarsys.cloudsuite.flow.common.CommonFlow;
import de.intarsys.cloudsuite.flow.common.FlowConfiguration;
import de.intarsys.cloudsuite.gears.action.IServerAction;
import de.intarsys.cloudsuite.gears.core.service.common.api.FlowOptions;
import de.intarsys.cloudsuite.gears.core.service.common.api.IOptionSupport;
import de.intarsys.cloudsuite.gears.core.service.common.api.RequestFlowCreate;
import de.intarsys.cloudsuite.gears.core.service.common.impl.RepositoryDocumentState;
import de.intarsys.cloudsuite.gears.core.service.common.impl.RequestExecute;
import de.intarsys.cloudsuite.gears.core.service.common.impl.ResponseExecute;
import de.intarsys.cloudsuite.gears.core.service.common.impl.SvcInteractive;
import de.intarsys.cloudsuite.gears.core.service.viewer.api.RequestViewerCreate;
import de.intarsys.cloudsuite.gears.core.service.viewer.api.ResponseViewerCreate;
import de.intarsys.cloudsuite.gears.core.service.viewer.api.ResultViewer;
import de.intarsys.cloudsuite.gears.core.service.viewer.impl.FlowViewer;
import de.intarsys.cloudsuite.gears.core.service.viewer.impl.FlowViewerConfiguration;
import de.intarsys.cloudsuite.gears.core.service.viewer.impl.RequestAddArtifact;
import de.intarsys.cloudsuite.gears.core.service.viewer.impl.RequestDownload;
import de.intarsys.cloudsuite.gears.core.service.viewer.impl.RequestGetAspect;
import de.intarsys.cloudsuite.gears.core.service.viewer.impl.RequestGetImage;
import de.intarsys.cloudsuite.gears.core.service.viewer.impl.RequestGetParameters;
import de.intarsys.cloudsuite.gears.core.service.viewer.impl.RequestSetArtifact;
import de.intarsys.cloudsuite.gears.core.service.viewer.impl.ResponseAddArtifact;
import de.intarsys.cloudsuite.gears.core.service.viewer.impl.ResponseGetAspect;
import de.intarsys.cloudsuite.gears.core.service.viewer.impl.ResponseGetParameters;
import de.intarsys.cloudsuite.gears.core.service.viewer.impl.ResponseSetArtifact;
import de.intarsys.cloudsuite.gears.flow.common.CoreFlow;
import de.intarsys.cloudsuite.gears.repository.impl.RepositoryDocument;
import de.intarsys.cloudsuite.gears.repository.impl.RepositoryItem;
import de.intarsys.cloudsuite.gears.repository.impl.RestrictedIdentificationProvider;
import de.intarsys.cloudsuite.tools.common.ArgsTransformer;
import de.intarsys.conversation.service.client.api.ConversationalResponse;
import de.intarsys.conversation.service.client.api.IntegrationOptions;
import de.intarsys.conversation.service.component.api.Outcome;
import de.intarsys.document.aspect.AspectEnvironment;
import de.intarsys.document.aspect.IAspect;
import de.intarsys.document.aspect.IAspectType;
import de.intarsys.document.aspect.IStreamingAspect;
import de.intarsys.document.aspect.type.common.BasicPropertiesAspect;
import de.intarsys.document.aspect.type.common.BasicPropertiesAspectType;
import de.intarsys.document.aspect.type.rendering.DocumentRenderingAspectType;
import de.intarsys.document.common.DocumentTools;
import de.intarsys.document.model.IDocument;
import de.intarsys.security.validation.serialization.ValidationNodeModule;
import de.intarsys.tools.concurrent.SynchronousExecutorService;
import de.intarsys.tools.content.IMimeTypeSupport;
import de.intarsys.tools.conversation.ConversationRegistry;
import de.intarsys.tools.conversation.Conversational;
import de.intarsys.tools.conversation.IConversation;
import de.intarsys.tools.conversation.IReplyStage;
import de.intarsys.tools.conversation.impl.Conversation;
import de.intarsys.tools.conversation.impl.HttpRedirectStage;
import de.intarsys.tools.conversation.impl.MonitorConversation;
import de.intarsys.tools.conversation.service.impl.ConversationServiceTools;
import de.intarsys.tools.exception.EncodedException;
import de.intarsys.tools.exception.ErrorObject;
import de.intarsys.tools.exception.ExceptionTools;
import de.intarsys.tools.expression.EvaluationException;
import de.intarsys.tools.expression.IStringEvaluator;
import de.intarsys.tools.expression.MapResolver;
import de.intarsys.tools.expression.Mode;
import de.intarsys.tools.expression.TemplateEvaluator;
import de.intarsys.tools.file.PathTools;
import de.intarsys.tools.function.Throwing;
import de.intarsys.tools.functor.ArgTools;
import de.intarsys.tools.functor.Args;
import de.intarsys.tools.functor.IArgs;
import de.intarsys.tools.jaxrs.IResponseCustomizer;
import de.intarsys.tools.jaxrs.RequestContext;
import de.intarsys.tools.jaxrs.ServiceImplementor;
import de.intarsys.tools.jaxrs.Stateful;
import de.intarsys.tools.lang.LangTools;
import de.intarsys.tools.loadbalance.LoadBalanceContext;
import de.intarsys.tools.loadbalance.LoadBalanced;
import de.intarsys.tools.locator.ILocator;
import de.intarsys.tools.logging.slf4j.Slf4jTools;
import de.intarsys.tools.stream.StreamTools;
import de.intarsys.tools.string.StringTools;
import de.intarsys.tools.tag.TagTools;
import de.intarsys.tools.zones.IZone;
import de.intarsys.widget.model.ActionSpec;
import de.intarsys.widget.model.WidgetDefinition;
import io.swagger.v3.oas.annotations.Operation;
import jakarta.annotation.PostConstruct;
import jakarta.ws.rs.Consumes;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.POST;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.QueryParam;
import jakarta.ws.rs.WebApplicationException;
import jakarta.ws.rs.core.Response;
import jakarta.ws.rs.core.StreamingOutput;
import jakarta.ws.rs.core.UriBuilder;
import java.awt.color.ICC_Profile;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.stream.IntStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.event.Level;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.core.env.ConfigurableEnvironment;
import org.springframework.core.env.Profiles;
import org.springframework.stereotype.Component;

@Path(value="/v1/flow/viewer")
@Component
@ServiceImplementor
public class SvcViewer
extends SvcInteractive<ResultViewer, FlowViewerConfiguration> {
    private static final String PARAM_LANG = "lang";
    private static final String PARAM_STATE = "state";
    private static final String PARAM_URL_SERVER = "urlServer";
    public static final String SERVICE_PATH = "/v1/flow/viewer/create";
    public static final String PRESENTATION_FOLDER = "ng";
    public static final String PATH_VIEWER = "viewer";
    public static final String CONTENT_TYPE_IMAGE = "image/";
    private static final Logger Log = LoggerFactory.getLogger(SvcViewer.class);
    @Autowired
    private AspectEnvironment aspectEnvironment;
    @Value(value="${viewer.rendering.timeout:20}")
    private int timeout = 20;
    @Autowired
    private ConfigurableEnvironment environment;

    @Conversational
    @LoadBalanced
    @Stateful(role=Stateful.Role.Consumer)
    @POST
    @Path(value="/addArtifact")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @Operation(hidden=true, operationId="viewerAddArtifact")
    public ResponseAddArtifact addArtifact(RequestAddArtifact request) throws Exception {
        IConversation conversation = this.lookupConversation(request.getConversationHandle());
        FlowViewer flow = (FlowViewer)CommonFlow.getFlow((IConversation)conversation, FlowViewer.class);
        return (ResponseAddArtifact)this.runInContext((CoreFlow)flow, f -> {
            ((FlowViewer)((Object)f)).addArtifact(request.getArtifact());
            return new ResponseAddArtifact();
        });
    }

    @Conversational
    @LoadBalanced
    @Stateful(role=Stateful.Role.Producer)
    @POST
    @Path(value="/create")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @Operation
    public ResponseViewerCreate create(RequestViewerCreate request) {
        FlowViewer flow = this.createFlow(request);
        IZone zone = this.createZone((CoreFlow)flow);
        try {
            this.validateRequest(request);
            IAuthentication authentication = AuthenticationProvider.get().getAuthentication();
            flow.setAuthenticationContext(authentication);
            flow.setLabel(request.getLabel());
            flow.setOptions(request.getOptions());
            flow.setArgs(request.getArgs());
            flow.setRepoDocStates(this.createRepoDocStates(request));
            flow.addAdditionalResolver((IStringEvaluator)this.createResolver((CommonFlow)flow));
            zone.wrap(f -> {
                flow.setConfiguration((FlowConfiguration)this.getConfiguration((RequestFlowCreate)request));
                this.createEncryption(flow);
                IntegrationOptions integrationOptions = FlowOptions.getIntegrationOptions((IOptionSupport)flow);
                ConversationServiceTools.setRootConversation(flow.getConversation());
                ConversationServiceTools.setIntegrationOptions(flow.getConversation(), (IntegrationOptions)integrationOptions);
                flow.getConversation().monitor(zone.wrap((Throwing.Specific.Supplier)((Throwing.Supplier)() -> this.createMainConversation(flow))));
            }).accept(flow);
        }
        catch (Exception e) {
            flow.getConversation().completeExceptionally((Throwable)e);
        }
        flow.getConversation().forwardTermination();
        this.getConversationRegistry().publish(flow.getConversation());
        ResponseViewerCreate response = new ResponseViewerCreate();
        this.finishRequest((ConversationalResponse)response, flow.getConversation());
        return response;
    }

    protected FlowViewerConfiguration createDefaultConfiguration() {
        FlowViewerConfiguration config = new FlowViewerConfiguration();
        config.setId("default");
        config.setWidgets(new ArrayList());
        return config;
    }

    protected IDocument createDocument(FlowViewer flow) throws IOException {
        RepositoryDocument repoDoc = ((RepositoryDocumentState)flow.getRepoDocStates().iterator().next()).getRepoDoc();
        ILocator locator = repoDoc.getLocator();
        try {
            return DocumentTools.createDocument((Object)locator);
        }
        catch (Exception e) {
            if (Log.isEnabledForLevel(Level.DEBUG)) {
                Log.warn("error creating document {}: {}", new Object[]{locator, ExceptionTools.getMessage((Throwable)e), e});
            } else {
                Log.warn("error creating document {}: {}", (Object)locator, (Object)ExceptionTools.getMessage((Throwable)e));
            }
            ErrorObject error = ErrorObject.create((Throwable)e);
            return DocumentTools.createFromImpl((String)"de.intarsys.document.type.error.ErrorDocumentType", (ILocator)locator, (Object)error);
        }
    }

    protected FlowViewer createFlow(RequestViewerCreate request) {
        FlowViewer flow = new FlowViewer(this.getRepository());
        ExecutorService tmpExecutor = FlowOptions.isAsynch((IOptionSupport)request) ? executor : new SynchronousExecutorService();
        MonitorConversation r = new MonitorConversation("monitor", tmpExecutor);
        r.exceptionally(ex -> {
            flow.dispose();
            throw Conversation.rethrowable((Throwable)ex);
        });
        flow.setConversation((IConversation)r);
        Slf4jTools.addCorrelation(null, (String)flow.getId());
        return flow;
    }

    protected IConversation<ResultViewer> createMainConversation(FlowViewer flow) {
        UriBuilder uriBuilder;
        this.runAssertions((CommonFlow)flow, "before");
        SvcViewer.authorizeArgs((String)SERVICE_PATH, (IArgs)flow.getArgs());
        if (flow.getConfiguration().getArguments() != null) {
            ArgsTransformer transformer = new ArgsTransformer(flow.getConfiguration().getArguments(), true);
            flow.setArgs(transformer.apply(flow.getArgs()));
        }
        try (IDocument iDoc = this.createDocument(flow);){
            DocumentTools.detectTags((IDocument)iDoc, (IArgs)flow.getArgs());
            IStringEvaluator tagResolver = TagTools.createDetachedResolverTags((Object)iDoc);
            flow.addAdditionalResolver(tagResolver);
        }
        catch (Exception e) {
            throw ExceptionTools.wrap((Throwable)e);
        }
        Object configuration = LangTools.copyDeep((Object)flow.getArgs().get("configurations"));
        ArgTools.expandDeep((IArgs)flow.getArgs(), (IStringEvaluator)TemplateEvaluator.get((Mode)Mode.UNTRUSTED));
        flow.getArgs().put("configurations", configuration);
        this.runAssertions((CommonFlow)flow, "merged");
        this.configurationTweak(flow.getConfiguration(), flow.getArgs());
        Conversation conversation = new Conversation(PATH_VIEWER);
        RepositoryDocument repoDoc = ((RepositoryDocumentState)flow.getRepoDocStates().iterator().next()).getRepoDoc();
        String debugUrlClient = (String)flow.getOption("debug.urlClient");
        if (StringTools.isEmpty((String)debugUrlClient)) {
            uriBuilder = RequestContext.get().getUriBuilderContext();
            uriBuilder.path(PRESENTATION_FOLDER);
        } else {
            uriBuilder = UriBuilder.fromUri((String)debugUrlClient);
            LoadBalanceContext.get().processUri(uriBuilder);
            UriBuilder uriBuilderServer = RequestContext.get().getUriBuilderContext();
            uriBuilder.queryParam(PARAM_URL_SERVER, new Object[]{uriBuilderServer.build(new Object[0]).toString()});
        }
        uriBuilder.path(PATH_VIEWER);
        uriBuilder.queryParam(PARAM_STATE, new Object[]{conversation.getHandle()});
        String lang = FlowOptions.getLang((IOptionSupport)flow);
        if (!StringTools.isEmpty((String)lang)) {
            uriBuilder.replaceQueryParam(PARAM_LANG, new Object[]{lang});
        }
        HttpRedirectStage stage = new HttpRedirectStage(uriBuilder.build(new Object[0]), false, true);
        stage.onAck(arg_0 -> this.lambda$createMainConversation$5(flow, repoDoc, (IConversation)conversation, arg_0));
        conversation.setReplyStage((IReplyStage)stage);
        ConversationRegistry.publishForLifetime((IConversation)conversation);
        return conversation;
    }

    protected ObjectMapper createObjectMapper() {
        ObjectMapper mapper = super.createObjectMapper();
        mapper.registerModule((Module)new ValidationNodeModule());
        return mapper;
    }

    protected MapResolver createResolver(final CommonFlow flow) {
        MapResolver mapResolver = super.createResolver(flow);
        mapResolver.put("signerCreate", (Object)new IStringEvaluator(){

            public Object evaluate(String expression, IArgs args) throws EvaluationException {
                IArgs lookup = ArgTools.getArgs((IArgs)flow.getArgs(), (String)"signerCreate", null);
                if (lookup == null) {
                    lookup = ArgTools.getArgs((IArgs)flow.getVariables(), (String)"signerCreate", null);
                }
                if (lookup == null) {
                    return null;
                }
                return ArgTools.getPath((IArgs)lookup, (String)expression);
            }
        });
        return mapResolver;
    }

    protected StreamingOutput createStreamDocument(final RepositoryItem repoItem) {
        final Object ri = RestrictedIdentificationProvider.getRestrictedIdentification();
        StreamingOutput stream = new StreamingOutput(){

            public void write(OutputStream os) throws IOException, WebApplicationException {
                InputStream is = null;
                try {
                    RestrictedIdentificationProvider.enter((Object)ri);
                    ILocator locator = repoItem.getLocator();
                    is = locator.getInputStream();
                    StreamTools.copy((InputStream)is, (OutputStream)os);
                }
                catch (Exception e) {
                    try {
                        throw new IOException(e);
                    }
                    catch (Throwable throwable) {
                        RestrictedIdentificationProvider.leave();
                        StreamTools.close(is);
                        throw throwable;
                    }
                }
                RestrictedIdentificationProvider.leave();
                StreamTools.close((Closeable)is);
            }
        };
        return stream;
    }

    @Conversational
    @LoadBalanced
    @Stateful(role=Stateful.Role.Consumer)
    @POST
    @Path(value="/download")
    @Consumes(value={"application/json"})
    @Operation(hidden=true, operationId="viewerDownload")
    public Response download(RequestDownload request) throws Exception {
        IConversation conversation = this.lookupConversation(request.getConversationHandle());
        FlowViewer flow = (FlowViewer)CommonFlow.getFlow((IConversation)conversation, FlowViewer.class);
        return (Response)this.runInContext((CoreFlow)flow, f -> {
            RepositoryDocument item = ((RepositoryDocumentState)flow.getRepoDocStates().stream().findAny().get()).getRepoDoc();
            StreamingOutput stream = this.createStreamDocument((RepositoryItem)item);
            String filename = PathTools.getName((String)item.getMetadata().getName());
            return Response.ok((Object)stream).header("Content-type", (Object)"application/octet-stream").header("Content-Disposition", (Object)("attachment; filename=\"" + filename + "\"")).build();
        });
    }

    @Conversational
    @LoadBalanced
    @Stateful(role=Stateful.Role.Consumer)
    @POST
    @Path(value="/execute")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @Operation(hidden=true, operationId="viewerExecute")
    public ResponseExecute execute(RequestExecute request) throws Exception {
        IConversation conversation = this.lookupConversation(request.getConversationHandle());
        FlowViewer flow = (FlowViewer)CommonFlow.getFlow((IConversation)conversation, FlowViewer.class);
        return (ResponseExecute)this.runInContext((CoreFlow)flow, f -> {
            IConversation actionConversation;
            try {
                IServerAction action = this.createServerAction((CommonFlow)flow, request.getAction());
                IArgs args = request.getArgs();
                actionConversation = action.invoke((CoreFlow)flow, (IArgs)(args == null ? Args.create() : args));
            }
            catch (Exception e) {
                actionConversation = Conversation.failed((Throwable)e);
                Log.warn("conversation {} execute failed ({})", new Object[]{conversation, ExceptionTools.getMessage((Throwable)e), e});
            }
            ResponseExecute response = new ResponseExecute();
            this.finishRequest((ConversationalResponse)response, actionConversation);
            return response;
        });
    }

    @Conversational(conversationArgIndex=0)
    @LoadBalanced
    @Stateful(role=Stateful.Role.Consumer)
    @GET
    @Path(value="/aspect/{name:.*}")
    @Operation(hidden=true, operationId="viewerAspect")
    public Response getAspectGet(@QueryParam(value="conversation") String conversation, @QueryParam(value="aspect") String aspect) throws Exception {
        RequestGetAspect request = new RequestGetAspect();
        request.setAspect(aspect);
        request.setConversationHandle(conversation);
        return this.handleGetAspect(request);
    }

    @Conversational
    @LoadBalanced
    @Stateful(role=Stateful.Role.Consumer)
    @POST
    @Path(value="/aspect")
    @Consumes(value={"application/json"})
    @Operation(hidden=true, operationId="viewerAspect")
    public Response getAspectPost(RequestGetAspect request) throws Exception {
        return this.handleGetAspect(request);
    }

    protected Class<FlowViewerConfiguration> getConfigurationType() {
        return FlowViewerConfiguration.class;
    }

    @Conversational
    @LoadBalanced
    @Stateful(role=Stateful.Role.Consumer)
    @POST
    @Path(value="/getImage")
    @Consumes(value={"application/json"})
    @Produces(value={"application/octet-stream"})
    @Operation(hidden=true, operationId="viewerImage")
    public Response getImage(RequestGetImage request) throws Exception {
        IConversation conversation = this.lookupConversation(request.getConversationHandle());
        FlowViewer flow = (FlowViewer)CommonFlow.getFlow((IConversation)conversation, FlowViewer.class);
        return (Response)this.runInContext((CoreFlow)flow, f -> {
            IDocument document = null;
            try {
                IAspectType aspectType = this.aspectEnvironment.getAspectType(DocumentRenderingAspectType.ID);
                document = this.createDocument(flow);
                Args aspectArgs = Args.create();
                aspectArgs.put("pageIndex", (Object)request.getPageIndex());
                aspectArgs.put("renderingParameters", (Object)request.getRenderParams());
                aspectArgs.put("timeout", (Object)(request.getTimeout() == null ? this.getTimeout() : request.getTimeout().intValue()));
                final IAspect aspect = this.aspectEnvironment.getAspect(aspectType, document, (IArgs)aspectArgs);
                Response.ResponseBuilder rb = Response.ok();
                if (aspect instanceof IMimeTypeSupport) {
                    rb.type(((IMimeTypeSupport)aspect).getContentType());
                }
                if (aspect instanceof IResponseCustomizer) {
                    ((IResponseCustomizer)aspect).customize(rb);
                }
                if (aspect instanceof IStreamingAspect) {
                    StreamingOutput stream = new StreamingOutput(){

                        public void write(OutputStream os) throws IOException, WebApplicationException {
                            ((IStreamingAspect)((Object)aspect)).write(os);
                        }
                    };
                    rb.entity((Object)stream);
                } else {
                    ResponseGetAspect response = new ResponseGetAspect();
                    response.setAspect(aspect);
                    rb.entity((Object)response);
                }
                Response response = rb.build();
                return response;
            }
            finally {
                if (document != null) {
                    document.release(null);
                }
            }
        });
    }

    @Conversational
    @LoadBalanced
    @Stateful(role=Stateful.Role.Consumer)
    @POST
    @Path(value="/getParameters")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @Operation(hidden=true, operationId="viewerParameters")
    public ResponseGetParameters getParameters(RequestGetParameters request) throws Exception {
        if (request.getConversationHandle() == null) {
            return this.getParametersDefault(request);
        }
        IConversation conversation = this.lookupConversation(request.getConversationHandle());
        FlowViewer flow = (FlowViewer)CommonFlow.getFlow((IConversation)conversation, FlowViewer.class);
        return (ResponseGetParameters)this.runInContext((CoreFlow)flow, ignore -> {
            IDocument document = null;
            try {
                ResponseGetParameters response = new ResponseGetParameters();
                IAspectType aspectType = this.aspectEnvironment.getAspectType(BasicPropertiesAspectType.ID);
                document = this.createDocument(flow);
                IAspect aspect = this.aspectEnvironment.getAspect(aspectType, document, (IArgs)Args.create());
                if (aspect instanceof BasicPropertiesAspect) {
                    response.setPageCount(((BasicPropertiesAspect)aspect).getPageCount());
                }
                response.setLabel(flow.getLabel());
                FlowConfiguration tmpCopy = flow.getConfiguration().copy();
                tmpCopy.expand(TemplateEvaluator.get((Mode)Mode.UNTRUSTED));
                response.setConfiguration(tmpCopy);
                response.setArgs(flow.getArgs());
                response.setInvocations(flow.getInvocations());
                response.setDocumentType(document.getType().getId());
                response.setDocumentTags(TagTools.toArgs((Object)document, (String)""));
                ResponseGetParameters responseGetParameters = response;
                return responseGetParameters;
            }
            finally {
                if (document != null) {
                    document.release(null);
                }
            }
        });
    }

    protected ResponseGetParameters getParametersDefault(RequestGetParameters request) {
        ResponseGetParameters response = new ResponseGetParameters();
        response.setPageCount(0);
        response.setLabel("-");
        FlowViewerConfiguration configuration = (FlowViewerConfiguration)this.createConfiguration(null);
        response.setConfiguration((Object)configuration);
        this.widgetDefinitionCreateDefaults(configuration.getWidgets());
        return response;
    }

    public int getTimeout() {
        return this.timeout;
    }

    protected Response handleGetAspect(RequestGetAspect request) throws Exception {
        IConversation conversation = this.lookupConversation(request.getConversationHandle());
        FlowViewer flow = (FlowViewer)CommonFlow.getFlow((IConversation)conversation, FlowViewer.class);
        return (Response)this.runInContext((CoreFlow)flow, f -> {
            IDocument document = null;
            try {
                IAspectType aspectType = this.aspectEnvironment.getAspectType(request.getAspect());
                document = this.createDocument(flow);
                final IAspect aspect = this.aspectEnvironment.getAspect(aspectType, document, request.getArgs());
                Response.ResponseBuilder rb = Response.ok();
                if (aspect instanceof IMimeTypeSupport) {
                    rb.type(((IMimeTypeSupport)aspect).getContentType());
                }
                if (aspect instanceof IResponseCustomizer) {
                    ((IResponseCustomizer)aspect).customize(rb);
                }
                if (aspect instanceof IStreamingAspect) {
                    StreamingOutput stream = new StreamingOutput(){

                        public void write(OutputStream os) throws IOException, WebApplicationException {
                            ((IStreamingAspect)((Object)aspect)).write(os);
                        }
                    };
                    rb.entity((Object)stream);
                } else {
                    ResponseGetAspect response = new ResponseGetAspect();
                    response.setAspect(aspect);
                    rb.entity((Object)response);
                }
                Response response = rb.build();
                return response;
            }
            finally {
                if (document != null) {
                    document.release(null);
                }
            }
        });
    }

    @PostConstruct
    public void preloadIccProfilesForMultiThreadedAccess() {
        IntStream.of(1001, 1003, 1004, 1002, 1000).forEach(type -> ICC_Profile.getInstance(type).getData());
    }

    @Conversational
    @LoadBalanced
    @Stateful(role=Stateful.Role.Consumer)
    @POST
    @Path(value="/setArtifact")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @Operation(hidden=true, operationId="viewerSetArtifact")
    public ResponseSetArtifact setArtifact(RequestSetArtifact request) throws Exception {
        IConversation conversation = this.lookupConversation(request.getConversationHandle());
        FlowViewer flow = (FlowViewer)CommonFlow.getFlow((IConversation)conversation, FlowViewer.class);
        return (ResponseSetArtifact)this.runInContext((CoreFlow)flow, f -> {
            ((FlowViewer)((Object)f)).setArtifact(request.getArtifact());
            return new ResponseSetArtifact();
        });
    }

    public void setTimeout(int timeout) {
        this.timeout = timeout;
    }

    protected void validateRequest(RequestViewerCreate request) {
        if (request == null) {
            throw new IllegalArgumentException("request can not be empty");
        }
    }

    protected void widgetDefinitionsCreateService(List<WidgetDefinition> widgetDefinitions) {
        WidgetDefinition child;
        boolean addDefaultRight;
        boolean addDefaultLeft;
        boolean bl = addDefaultLeft = !this.widgetDefinitionHasChildren(widgetDefinitions, "de.intarsys.widget.toolbar.left");
        if (addDefaultLeft) {
            WidgetDefinition.Builder builder = WidgetDefinition.builder((WidgetDefinition)this.widgetDefinitionGet(widgetDefinitions, "de.intarsys.widget.toolbar.left"));
            builder.child().icon("file").on("visible", (Object)ActionSpec.build((String)"IsDetached", null)).child("documentOpen").on("select", (Object)ActionSpec.build((String)"DocumentOpen", null)).end().child("documentClose").on("select", (Object)ActionSpec.build((String)"DocumentClose", null)).end().child("download").on("select", (Object)ActionSpec.build((String)"Download", null)).end().end().child("pagePrevious").on("select", (Object)ActionSpec.build((String)"SelectPagePrevious", null)).end().child("pageSelector").type("de.intarsys.ui.control.PageSelector").end().child("pageNext").on("select", (Object)ActionSpec.build((String)"SelectPageNext", null)).end().child("zoomIn").on("select", (Object)ActionSpec.build((String)"ZoomIn", null)).end().child("zoomOut").on("select", (Object)ActionSpec.build((String)"ZoomOut", null)).end().child("zoomPageHeight").on("select", (Object)ActionSpec.build((String)"ZoomPageHeight", null)).end().child("zoomPageWidth").on("select", (Object)ActionSpec.build((String)"ZoomPageWidth", null)).end().child("zoomPage").on("select", (Object)ActionSpec.build((String)"ZoomPage", null)).end().child().type("Separator").end();
        }
        if (!this.widgetDefinitionHasChildren(widgetDefinitions, "de.intarsys.widget.toolbar.center")) {
            WidgetDefinition child2 = WidgetDefinition.builder().id("label").parentName("de.intarsys.widget.toolbar.center").type("Label").label("${flow.label:!\"-\"}").build();
            widgetDefinitions.add(child2);
        }
        boolean bl2 = addDefaultRight = !this.widgetDefinitionHasChildren(widgetDefinitions, "de.intarsys.widget.toolbar.right");
        if (!this.widgetDefinitionHasWidget(widgetDefinitions, "debugOptions") && this.environment.acceptsProfiles(Profiles.of((String[])new String[]{"dev"}))) {
            child = WidgetDefinition.builder().id("debugOptions").parentName("de.intarsys.widget.toolbar.right").on("select", (Object)ActionSpec.build((String)"OpenDebugOptions", null)).build();
            widgetDefinitions.add(child);
        }
        if (addDefaultRight) {
            child = WidgetDefinition.builder().id("activeOperations").parentName("de.intarsys.widget.toolbar.right").property("fa.spin", (Object)"true").on("select", (Object)ActionSpec.build((String)"OpenActiveOperations", null)).build();
            widgetDefinitions.add(child);
            child = WidgetDefinition.builder().id("settings").parentName("de.intarsys.widget.toolbar.right").on("select", (Object)ActionSpec.build((String)"OpenSettings", null)).build();
            widgetDefinitions.add(child);
            child = WidgetDefinition.builder().id("exit").parentName("de.intarsys.widget.toolbar.right").on("select", (Object)ActionSpec.build((String)"Ok", null)).on("visible", (Object)ActionSpec.build((String)"!IsDetached", null)).build();
            widgetDefinitions.add(child);
        }
    }

    private /* synthetic */ void lambda$createMainConversation$5(FlowViewer flow, RepositoryDocument repoDoc, IConversation conversation, Object outcome) {
        try {
            this.runInContext((CoreFlow)flow, f -> {
                try {
                    Outcome tempOutcome = Outcome.create((Object)outcome);
                    if (tempOutcome != null) {
                        if (tempOutcome.isOk()) {
                            ResultViewer result = new ResultViewer();
                            result.setDocumentName(repoDoc.getLocator().getName());
                            result.setArtifacts(flow.getArtifacts());
                            conversation.complete((Object)result);
                        } else if (Outcome.create((Object)outcome).isFail()) {
                            conversation.completeExceptionally((Throwable)new EncodedException("unknown", "unknown"));
                        } else if (Outcome.create((Object)outcome).isCancel()) {
                            conversation.cancel(false);
                        }
                    }
                }
                catch (Exception e) {
                    conversation.completeExceptionally((Throwable)new EncodedException("unknown", (Throwable)e));
                }
                return null;
            });
        }
        catch (Exception e) {
            RuntimeException ex = new RuntimeException("unexpected exception", e);
            conversation.completeExceptionally((Throwable)ex);
        }
    }
}

