/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.cloudsuite.gears.core.test;

import de.intarsys.aaa.authorization.api.AuthorizationException;
import de.intarsys.aaa.authorization.api.AuthorizationStrategy;
import de.intarsys.aaa.resource.IOperation;
import de.intarsys.aaa.resource.IResource;
import de.intarsys.aaa.resource.SimpleObjectResource;
import de.intarsys.aaa.resource.SimpleOperation;
import de.intarsys.cloudsuite.gears.action.ActionInvocation;
import de.intarsys.cloudsuite.gears.action.ServerAction;
import de.intarsys.cloudsuite.gears.core.service.common.api.DtoArtifact;
import de.intarsys.cloudsuite.gears.core.test.TestflowResult;
import de.intarsys.conversation.service.client.api.IntegrationOptions;
import de.intarsys.conversation.service.component.api.Outcome;
import de.intarsys.tools.conversation.ConversationRegistry;
import de.intarsys.tools.conversation.IConversation;
import de.intarsys.tools.conversation.IReplyStage;
import de.intarsys.tools.conversation.impl.Conversation;
import de.intarsys.tools.conversation.impl.HttpRedirectStage;
import de.intarsys.tools.conversation.impl.ProcessingStage;
import de.intarsys.tools.conversation.service.impl.ConversationServiceTools;
import de.intarsys.tools.exception.EncodedException;
import de.intarsys.tools.functor.ArgTools;
import de.intarsys.tools.functor.IArgs;
import de.intarsys.tools.jaxrs.JaxrsTools;
import de.intarsys.tools.jaxrs.RequestContext;
import de.intarsys.tools.string.StringTools;
import jakarta.ws.rs.core.UriBuilder;
import java.util.Map;

public class Testflow
extends ServerAction {
    public static final IResource AUTH_RESOURCE = SimpleObjectResource.createFromClass(Testflow.class);
    private static final String CONVERSATION_NAME = "test";
    private static final String PARAM_STATE = "state";
    private static final String ARG_WINDOW_TARGET = "target";
    private static final String ARG_REDIRECT_URI = "redirectUri";
    private static final String ARG_OOB = "oob";
    private static final String ARG_WINDOW_SPECS = "specs";
    private static final String DEFAULT_WINDOW_SPECS = "top=0,left=0,menubar=no,toolbar=no,location=no,resizeable=on";
    private String message = "";
    private String resource = null;
    private String operation = null;

    protected IConversation<?> basicInvoke(ActionInvocation invocation) throws Exception {
        UriBuilder uriBuilder;
        AuthorizationStrategy.get().checkAccess(AUTH_RESOURCE, null);
        String specs = ArgTools.getString((IArgs)invocation.getArgs(), (String)ARG_WINDOW_SPECS, (String)DEFAULT_WINDOW_SPECS);
        String target = ArgTools.getString((IArgs)invocation.getArgs(), (String)ARG_WINDOW_TARGET, null);
        String redirectUri = ArgTools.getString((IArgs)invocation.getArgs(), (String)ARG_REDIRECT_URI, null);
        boolean oob = ArgTools.getBoolStrict((IArgs)invocation.getArgs(), (String)ARG_OOB, (boolean)false);
        Conversation conversation = new Conversation(CONVERSATION_NAME);
        IntegrationOptions integrationOptions = new IntegrationOptions();
        integrationOptions.setRedirectUri(redirectUri);
        ConversationServiceTools.setIntegrationOptions((IConversation)conversation, (IntegrationOptions)integrationOptions);
        ConversationServiceTools.setOobActive((IConversation)conversation, (boolean)oob);
        ConversationServiceTools.setRootConversation((IConversation)conversation);
        String debugUrlClient = (String)invocation.getFlow().getOption("debug.urlClient");
        if (StringTools.isEmpty((String)debugUrlClient)) {
            uriBuilder = RequestContext.get().getUriBuilderContext();
            uriBuilder.path("ng");
        } else {
            uriBuilder = UriBuilder.fromUri((String)debugUrlClient);
            UriBuilder uriBuilderServer = JaxrsTools.getUriBuilderContext();
            uriBuilder.queryParam("urlServer", new Object[]{uriBuilderServer.toString()});
        }
        uriBuilder.path(CONVERSATION_NAME);
        uriBuilder.queryParam(PARAM_STATE, new Object[]{conversation.getHandle()});
        HttpRedirectStage httpRedirectStage = new HttpRedirectStage(uriBuilder.build(new Object[0]).toString(), oob, false);
        httpRedirectStage.setSpecs(specs);
        httpRedirectStage.setName(target);
        httpRedirectStage.onAck(arg_0 -> this.lambda$basicInvoke$0((IConversation)conversation, arg_0));
        conversation.setReplyStage((IReplyStage)httpRedirectStage);
        conversation.thenApply(result -> {
            invocation.getFlow().addArtifact(new DtoArtifact(CONVERSATION_NAME, result));
            return null;
        });
        ConversationRegistry.publishForLifetime((IConversation)conversation);
        this.getConversationRegistry().publish((IConversation)conversation);
        return conversation;
    }

    public String getMessage() {
        return this.message;
    }

    public String getOperation() {
        return this.operation;
    }

    public String getResource() {
        return this.resource;
    }

    protected void handleAcknowledge(IConversation conversation, Object value) {
        Outcome outcome = null;
        try {
            outcome = Outcome.create((Object)value);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        if (outcome == null) {
            if (value instanceof Map) {
                this.setMessage((String)((Map)value).get("message"));
                this.setResource((String)((Map)value).get("resource"));
                this.setOperation((String)((Map)value).get("operation"));
            }
            ProcessingStage processingStage = new ProcessingStage("warte auf beendigung");
            processingStage.onAck(ack -> this.handleAcknowledge(conversation, ack));
            conversation.setReplyStage((IReplyStage)processingStage);
        } else if (outcome.isOk()) {
            if (!StringTools.isEmpty((String)this.getResource())) {
                try {
                    AuthorizationStrategy.get().checkAccess((IResource)SimpleObjectResource.parse((String)this.getResource()), (IOperation)SimpleOperation.parse((String)this.getOperation()));
                }
                catch (AuthorizationException e) {
                    conversation.completeExceptionally((Throwable)e);
                    return;
                }
            }
            TestflowResult result = new TestflowResult();
            result.setMessage(this.getMessage());
            conversation.complete((Object)result);
        } else if (outcome.isFail()) {
            conversation.completeExceptionally((Throwable)new EncodedException("unknown", this.getMessage()));
        } else if (outcome.isCancel()) {
            conversation.cancel(false);
        }
    }

    public void setMessage(String message) {
        this.message = message;
    }

    public void setOperation(String operation) {
        this.operation = operation;
    }

    public void setResource(String resource) {
        this.resource = resource;
    }

    private /* synthetic */ void lambda$basicInvoke$0(IConversation conversation, Object ack) {
        this.handleAcknowledge(conversation, ack);
    }
}

