/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.cloudsuite.gears.devicecontrol.backend;

import de.intarsys.security.app.ApplicationException;
import de.intarsys.security.app.IAuthenticatedApplication;
import de.intarsys.security.app.principal.IPrincipalAdministration;
import de.intarsys.security.app.signature.ISigner;
import de.intarsys.security.certificate.CertificateTools;
import de.intarsys.security.certificate.IX509PublicKeyCertificate;
import de.intarsys.security.certificate.filter.CertificateFilterTools;
import de.intarsys.security.certificate.filter.IX509CertificateFilter;
import de.intarsys.security.certificate.filter.OrListCertificateFilter;
import de.intarsys.security.certificate.filter.standard.X509CertificateSelector;
import de.intarsys.security.device.DeviceProviderRegistry;
import de.intarsys.security.device.DeviceTools;
import de.intarsys.security.device.ICredential;
import de.intarsys.security.device.IDevice;
import de.intarsys.security.device.IDeviceProvider;
import de.intarsys.security.device.IPrincipal;
import de.intarsys.security.device.IPrincipalFilter;
import de.intarsys.security.device.IX509Principal;
import de.intarsys.security.device.common.PrincipalFilterTools;
import de.intarsys.security.device.pool.device.PoolDevice;
import de.intarsys.security.device.pool.impl.CommonPoolListener;
import de.intarsys.security.environment.SecurityEnvironment;
import de.intarsys.tools.conversation.IConversation;
import de.intarsys.tools.conversation.impl.Conversation;
import de.intarsys.tools.crypto.CryptoTools;
import de.intarsys.tools.crypto.Secret;
import de.intarsys.tools.exception.ExceptionTools;
import de.intarsys.tools.functor.Args;
import de.intarsys.tools.functor.IArgs;
import de.intarsys.tools.reflect.ObjectCreationException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.springframework.stereotype.Component;

@Component
public class CtrlDevice {
    public IDevice addFilterExpression(String poolDeviceProviderId, String poolDeviceId, String expression) {
        IX509CertificateFilter filter;
        IDevice tmpDevice = this.getDevice(poolDeviceProviderId, poolDeviceId);
        if (!(tmpDevice instanceof PoolDevice)) {
            throw new IllegalArgumentException("pool device not valid");
        }
        PoolDevice poolDevice = (PoolDevice)tmpDevice;
        if (!(poolDevice.getPoolListener() instanceof CommonPoolListener)) {
            throw new IllegalArgumentException("pool device not valid");
        }
        CommonPoolListener poolListener = (CommonPoolListener)poolDevice.getPoolListener();
        try {
            filter = CertificateFilterTools.createCertificateFilter((Object)expression);
        }
        catch (ObjectCreationException e) {
            throw new IllegalArgumentException("filter expression invalid (" + ExceptionTools.getMessageShort((Throwable)e) + ")");
        }
        IX509CertificateFilter newFilter = OrListCertificateFilter.or((IX509CertificateFilter)poolListener.getCertificateFilter(), (IX509CertificateFilter)filter);
        poolListener.setCertificateFilter(newFilter);
        poolDevice.preferencesStore();
        return poolDevice;
    }

    public IDevice addFilterPrincipal(String poolDeviceProviderId, String poolDeviceId, String deviceProviderId, String deviceId, String principalId) {
        IDevice tmpDevice = this.getDevice(poolDeviceProviderId, poolDeviceId);
        if (!(tmpDevice instanceof PoolDevice)) {
            throw new IllegalArgumentException("pool device not valid");
        }
        PoolDevice poolDevice = (PoolDevice)tmpDevice;
        if (!(poolDevice.getPoolListener() instanceof CommonPoolListener)) {
            throw new IllegalArgumentException("pool device not valid");
        }
        CommonPoolListener poolListener = (CommonPoolListener)poolDevice.getPoolListener();
        IPrincipal principal = this.getPrincipal(deviceProviderId, deviceId, principalId);
        if (!(principal instanceof IX509Principal)) {
            throw new IllegalArgumentException("principal not valid");
        }
        if (!((IX509Principal)principal).isKeyOwner()) {
            throw new IllegalArgumentException("principal not key owner");
        }
        IX509PublicKeyCertificate cert = ((IX509Principal)principal).getX509PublicKeyCertificate();
        X509CertificateSelector selector = X509CertificateSelector.createUniqueSelector((IX509PublicKeyCertificate)cert);
        IX509CertificateFilter newFilter = OrListCertificateFilter.or((IX509CertificateFilter)poolListener.getCertificateFilter(), (IX509CertificateFilter)selector);
        poolListener.setCertificateFilter(newFilter);
        poolDevice.preferencesStore();
        return poolDevice;
    }

    public IDevice control(String deviceProviderId, String deviceId, String command) throws ApplicationException {
        IDevice device = this.getDevice(deviceProviderId, deviceId);
        if (device == null) {
            return null;
        }
        device.control(command, (IArgs)Args.create());
        return device;
    }

    public IConversation<IPrincipal> createPrincipal(String deviceProviderId, String deviceId, IArgs args) throws Exception {
        IDevice device = this.getDevice(deviceProviderId, deviceId);
        if (device == null) {
            return Conversation.failed((Throwable)new IllegalArgumentException("device not valid"));
        }
        IPrincipalAdministration principalAdministration = (IPrincipalAdministration)device.createApplication(IPrincipalAdministration.class.getName(), args);
        if (principalAdministration == null) {
            return Conversation.failed((Throwable)new IllegalArgumentException("device does not support principal creation"));
        }
        IConversation conversation = principalAdministration.createPrincipal();
        return conversation;
    }

    public IDevice editPoolProperties(String poolDeviceProviderId, String poolDeviceId, boolean autoStart, long timeout) {
        IDevice tmpDevice = this.getDevice(poolDeviceProviderId, poolDeviceId);
        if (!(tmpDevice instanceof PoolDevice)) {
            throw new IllegalArgumentException("pool device not valid");
        }
        PoolDevice poolDevice = (PoolDevice)tmpDevice;
        if (!(poolDevice.getPoolListener() instanceof CommonPoolListener)) {
            throw new IllegalArgumentException("pool device not valid");
        }
        CommonPoolListener poolListener = (CommonPoolListener)poolDevice.getPoolListener();
        poolListener.getPool().setAutoStart(autoStart);
        poolListener.getPool().setTimeout(timeout);
        poolDevice.preferencesStore();
        return poolDevice;
    }

    public ICredential getCredential(String deviceProviderId, String deviceId, String credentialId) {
        return this.getCredentials(deviceProviderId, deviceId).stream().filter(c -> c.getId().equals(credentialId)).findFirst().orElse(null);
    }

    public List<ICredential> getCredentials(String deviceProviderId, String deviceId) {
        IDevice device = this.getDevice(deviceProviderId, deviceId);
        if (device == null) {
            return Collections.emptyList();
        }
        Iterator itResult = device.listCredentials(null);
        ArrayList<ICredential> result = new ArrayList<ICredential>();
        itResult.forEachRemaining(result::add);
        return result;
    }

    protected IDevice getDevice(String deviceProviderId, String deviceId) {
        IDeviceProvider<?> deviceProvider = this.getDeviceProvider(deviceProviderId);
        if (deviceProvider == null) {
            return null;
        }
        IDevice device = DeviceTools.lookupDevice(deviceProvider, (String)deviceId);
        if (device == null) {
            return null;
        }
        return device;
    }

    public IDeviceProvider<?> getDeviceProvider(String deviceProviderId) {
        return DeviceProviderRegistry.get().getDeviceProviders().stream().filter(dp -> dp.getId().equals(deviceProviderId)).findFirst().orElse(null);
    }

    public List<IDeviceProvider<?>> getDeviceProviders() {
        return DeviceProviderRegistry.get().getDeviceProviders();
    }

    public IPrincipal getPrincipal(String deviceProviderId, String deviceId, String principalId) {
        return this.getPrincipals(deviceProviderId, deviceId).stream().filter(p -> p.getId().equals(principalId)).findFirst().orElse(null);
    }

    public IX509PublicKeyCertificate getPrincipalCertificate(String deviceProviderId, String deviceId, String principalId) {
        IPrincipal principal = this.getPrincipal(deviceProviderId, deviceId, principalId);
        if (!(principal instanceof IX509Principal)) {
            return null;
        }
        IX509Principal x509Principal = (IX509Principal)principal;
        return x509Principal.getX509PublicKeyCertificate();
    }

    public List<IPrincipal> getPrincipals(String deviceProviderId, String deviceId) {
        IDevice device = this.getDevice(deviceProviderId, deviceId);
        if (device == null) {
            return Collections.emptyList();
        }
        Iterator itResult = device.listPrincipals(null);
        ArrayList<IPrincipal> result = new ArrayList<IPrincipal>();
        itResult.forEachRemaining(result::add);
        return result;
    }

    public void pinCacheClear(String deviceProviderId, String deviceId, String principalId) {
        IPrincipal principal = this.getPrincipal(deviceProviderId, deviceId, principalId);
        if (!(principal instanceof IX509Principal)) {
            throw new IllegalArgumentException("principal not valid");
        }
        if (!((IX509Principal)principal).isKeyOwner()) {
            throw new IllegalArgumentException("principal not key owner");
        }
        IX509PublicKeyCertificate cert = ((IX509Principal)principal).getX509PublicKeyCertificate();
        String id = CertificateTools.getUniqueIdentifier((IX509PublicKeyCertificate)cert);
        SecurityEnvironment.get().clearSecret(id);
    }

    public void pinCacheSet(String deviceProviderId, String deviceId, String principalId, Secret pin, boolean store) throws Exception {
        IPrincipal principal = this.getPrincipal(deviceProviderId, deviceId, principalId);
        if (!(principal instanceof IX509Principal)) {
            throw new IllegalArgumentException("principal not valid");
        }
        if (!((IX509Principal)principal).isKeyOwner()) {
            throw new IllegalArgumentException("principal not key owner");
        }
        IX509PublicKeyCertificate cert = ((IX509Principal)principal).getX509PublicKeyCertificate();
        String id = CertificateTools.getUniqueIdentifier((IX509PublicKeyCertificate)cert);
        ISigner appSigner = null;
        try {
            Args argsSigner = Args.create();
            argsSigner.put("signerIdentifier", (Object)principal);
            appSigner = (ISigner)principal.getDevice().createApplication(ISigner.class.getName(), (IArgs)argsSigner);
            if (!(appSigner instanceof IAuthenticatedApplication)) {
                return;
            }
            ((IAuthenticatedApplication)appSigner).setAuthenticationPin(pin);
            ((IAuthenticatedApplication)appSigner).authenticate().get();
            if (CryptoTools.isEmpty((Secret)pin)) {
                SecurityEnvironment.get().clearSecret(id);
            } else {
                SecurityEnvironment.get().setSecret(id, pin, store);
            }
        }
        catch (Exception e) {
            SecurityEnvironment.get().clearSecret(id);
            throw e;
        }
        finally {
            if (appSigner != null) {
                appSigner.dispose();
            }
        }
    }

    public IDevice removeFilterIndex(String poolDeviceProviderId, String poolDeviceId, int index) {
        IDevice tmpDevice = this.getDevice(poolDeviceProviderId, poolDeviceId);
        if (!(tmpDevice instanceof PoolDevice)) {
            throw new IllegalArgumentException("pool device not valid");
        }
        PoolDevice poolDevice = (PoolDevice)tmpDevice;
        if (!(poolDevice.getPoolListener() instanceof CommonPoolListener)) {
            throw new IllegalArgumentException("pool device not valid");
        }
        CommonPoolListener listener = (CommonPoolListener)poolDevice.getPoolListener();
        IX509CertificateFilter newFilter = OrListCertificateFilter.remove((IX509CertificateFilter)listener.getCertificateFilter(), (int)index);
        listener.setCertificateFilter(newFilter);
        poolDevice.preferencesStore();
        return poolDevice;
    }

    public IPrincipal removePrincipal(String deviceProviderId, String deviceId, String principalId) throws Exception {
        IDevice device = this.getDevice(deviceProviderId, deviceId);
        if (device == null) {
            throw new IllegalArgumentException("device not valid");
        }
        IPrincipal principal = this.getPrincipal(deviceProviderId, deviceId, principalId);
        if (principal == null) {
            throw new IllegalArgumentException("principal not valid");
        }
        Args keyArgs = Args.create();
        IPrincipalAdministration principalAdministration = (IPrincipalAdministration)device.createApplication(IPrincipalAdministration.class.getName(), (IArgs)keyArgs);
        if (principalAdministration == null) {
            throw new IllegalArgumentException("device does not support principal deletion");
        }
        IPrincipalFilter filter = PrincipalFilterTools.createFilter((Object)principal);
        principalAdministration.deletePrincipal(filter);
        return principal;
    }
}

