/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.cloudsuite.gears.devicecontrol.service;

import de.intarsys.cloudsuite.gears.devicecontrol.service.DtoNotice;
import de.intarsys.cloudsuite.gears.devicecontrol.service.DtoPool;
import de.intarsys.cloudsuite.gears.devicecontrol.service.DtoSecurityApplication;
import de.intarsys.security.app.IApplicationDescriptor;
import de.intarsys.security.app.ISecurityApplication;
import de.intarsys.security.device.IDevice;
import de.intarsys.security.device.pool.device.PoolDevice;
import de.intarsys.security.device.pool.impl.IPoolListener;
import de.intarsys.tools.infoset.ElementFactory;
import de.intarsys.tools.infoset.ElementSerializationException;
import de.intarsys.tools.infoset.IElement;
import de.intarsys.tools.infoset.IElementSerializable;
import de.intarsys.tools.infoset.JavaConverter;
import de.intarsys.tools.presentation.PresentationAdapter;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;

public class DtoDevice {
    private String type;
    private String id;
    private String label;
    private String state;
    private List<DtoNotice> notices;
    private DtoPool pool;
    private Object poolListener;
    private List<DtoSecurityApplication> securityApplications;

    public static DtoDevice create(IDevice device) {
        if (device == null) {
            return null;
        }
        DtoDevice result = new DtoDevice();
        result.setType(device.getClass().getName());
        result.setId(device.getId());
        result.setLabel(PresentationAdapter.create((Object)device, (String)device.getId()).getLabel());
        result.setState(device.getState().getId());
        result.setNotices(device.getNotices().stream().map(n -> DtoNotice.create(n)).collect(Collectors.toList()));
        if (device instanceof PoolDevice) {
            PoolDevice poolDevice = (PoolDevice)device;
            result.setPool(DtoPool.create(poolDevice.getPool()));
            IPoolListener poolListener = poolDevice.getPoolListener();
            if (poolListener instanceof IElementSerializable) {
                IElement element = ElementFactory.get().createElement("poolListener");
                try {
                    ((IElementSerializable)poolListener).serialize(element);
                }
                catch (ElementSerializationException e) {
                    throw new IllegalArgumentException(e);
                }
                result.setPoolListener(JavaConverter.convert((IElement)element));
            }
        }
        ArrayList<DtoSecurityApplication> securityApplications = new ArrayList<DtoSecurityApplication>();
        List descriptors = device.getDeviceProvider().getApplicationDescriptors();
        for (IApplicationDescriptor descriptor : descriptors) {
            DtoSecurityApplication dtoSecurityApplication = DtoSecurityApplication.create(device, (IApplicationDescriptor<ISecurityApplication>)descriptor);
            securityApplications.add(dtoSecurityApplication);
        }
        result.setSecurityApplications(securityApplications);
        return result;
    }

    public String getId() {
        return this.id;
    }

    public String getLabel() {
        return this.label;
    }

    public List<DtoNotice> getNotices() {
        return this.notices;
    }

    public DtoPool getPool() {
        return this.pool;
    }

    public Object getPoolListener() {
        return this.poolListener;
    }

    public List<DtoSecurityApplication> getSecurityApplications() {
        return this.securityApplications;
    }

    public String getState() {
        return this.state;
    }

    public String getType() {
        return this.type;
    }

    public void setId(String id) {
        this.id = id;
    }

    public void setLabel(String label) {
        this.label = label;
    }

    public void setNotices(List<DtoNotice> notices) {
        this.notices = notices;
    }

    public void setPool(DtoPool pool) {
        this.pool = pool;
    }

    public void setPoolListener(Object value) {
        this.poolListener = value;
    }

    public void setSecurityApplications(List<DtoSecurityApplication> securityApplications) {
        this.securityApplications = securityApplications;
    }

    public void setState(String state) {
        this.state = state;
    }

    public void setType(String type) {
        this.type = type;
    }
}

