/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.cloudsuite.gears.devicecontrol.service;

import de.intarsys.cloudsuite.gears.devicecontrol.service.DtoDevice;
import de.intarsys.security.device.IDeviceProvider;
import de.intarsys.tools.presentation.PresentationAdapter;
import java.util.ArrayList;
import java.util.List;

public class DtoDeviceProvider {
    private String id;
    private String label;
    private List<DtoDevice> devices;

    public static DtoDeviceProvider create(IDeviceProvider<?> value) {
        if (value == null) {
            return null;
        }
        DtoDeviceProvider result = new DtoDeviceProvider();
        result.setId(value.getId());
        result.setLabel(PresentationAdapter.create(value, (String)value.getId()).getLabel());
        ArrayList<DtoDevice> list = new ArrayList<DtoDevice>();
        value.listDevices(null).forEachRemaining(device -> list.add(DtoDevice.create(device)));
        list.sort((o1, o2) -> o1.getLabel().compareToIgnoreCase(o2.getLabel()));
        result.setDevices(list);
        return result;
    }

    public List<DtoDevice> getDevices() {
        return this.devices;
    }

    public String getId() {
        return this.id;
    }

    public String getLabel() {
        return this.label;
    }

    public void setDevices(List<DtoDevice> devices) {
        this.devices = devices;
    }

    public void setId(String id) {
        this.id = id;
    }

    public void setLabel(String label) {
        this.label = label;
    }
}

