/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.cloudsuite.gears.devicecontrol.service;

import de.intarsys.security.certificate.CertificateTools;
import de.intarsys.security.certificate.IX509Certificate;
import de.intarsys.security.certificate.IX509PublicKeyCertificate;
import de.intarsys.security.device.IPrincipal;
import de.intarsys.security.device.IX509Principal;
import de.intarsys.security.environment.SecurityEnvironment;
import de.intarsys.security.validation.serialization.DtoCertificate;
import de.intarsys.tools.crypto.CryptoTools;
import de.intarsys.tools.crypto.Secret;
import de.intarsys.tools.presentation.PresentationAdapter;

public class DtoPrincipal {
    private String id;
    private String label;
    private String certificateUsage;
    private String serialNumber;
    private boolean keyOwner;
    private boolean qualified;
    private boolean secretCached;
    private boolean allowSecretFromCache;
    private DtoCertificate certificate;

    public static DtoPrincipal create(IPrincipal value) {
        if (value == null) {
            return null;
        }
        IX509Principal x509Principal = (IX509Principal)value;
        DtoPrincipal result = new DtoPrincipal();
        result.setId(value.getId());
        String defaultLabel = x509Principal.getSubjectLabel();
        result.setLabel(PresentationAdapter.create((Object)value, (String)defaultLabel).getLabel());
        result.setCertificateUsage(x509Principal.getCertificateUsageLabel());
        result.setKeyOwner(x509Principal.isKeyOwner());
        result.setAllowSecretFromCache(x509Principal.isSecretCachable());
        String id = CertificateTools.getUniqueIdentifier((IX509PublicKeyCertificate)x509Principal.getX509PublicKeyCertificate());
        Secret secret = SecurityEnvironment.get().getSecret(id);
        result.setSecretCached(!CryptoTools.isEmpty((Secret)secret));
        result.setQualified(x509Principal.isQualified());
        result.setSerialNumber(x509Principal.getSerialNumber());
        IX509PublicKeyCertificate certificate = x509Principal.getX509PublicKeyCertificate();
        if (certificate != null) {
            result.setCertificate(DtoCertificate.create((IX509Certificate)certificate));
        }
        return result;
    }

    public DtoCertificate getCertificate() {
        return this.certificate;
    }

    public String getCertificateUsage() {
        return this.certificateUsage;
    }

    public String getId() {
        return this.id;
    }

    public String getLabel() {
        return this.label;
    }

    public String getSerialNumber() {
        return this.serialNumber;
    }

    public boolean isAllowSecretFromCache() {
        return this.allowSecretFromCache;
    }

    public boolean isKeyOwner() {
        return this.keyOwner;
    }

    public boolean isQualified() {
        return this.qualified;
    }

    public boolean isSecretCached() {
        return this.secretCached;
    }

    public void setAllowSecretFromCache(boolean secretCachable) {
        this.allowSecretFromCache = secretCachable;
    }

    public void setCertificate(DtoCertificate certificate) {
        this.certificate = certificate;
    }

    public void setCertificateUsage(String certificateUsage) {
        this.certificateUsage = certificateUsage;
    }

    public void setId(String id) {
        this.id = id;
    }

    public void setKeyOwner(boolean keyOwner) {
        this.keyOwner = keyOwner;
    }

    public void setLabel(String label) {
        this.label = label;
    }

    public void setQualified(boolean qualified) {
        this.qualified = qualified;
    }

    public void setSecretCached(boolean secretCached) {
        this.secretCached = secretCached;
    }

    public void setSerialNumber(String serialNumber) {
        this.serialNumber = serialNumber;
    }
}

