/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.cloudsuite.gears.devicecontrol.service;

import de.intarsys.security.app.ApplicationException;
import de.intarsys.security.app.IApplicationDescriptor;
import de.intarsys.security.app.ISecurityApplication;
import de.intarsys.security.device.IDevice;
import de.intarsys.tools.string.StringTools;
import java.util.List;

public class DtoSecurityApplication {
    private String type;
    private String operations;

    public static DtoSecurityApplication create(IDevice device, IApplicationDescriptor<ISecurityApplication> descriptor) {
        if (descriptor == null) {
            return null;
        }
        DtoSecurityApplication result = new DtoSecurityApplication();
        result.setType(descriptor.getType().getName());
        try {
            String opString = StringTools.join((List)descriptor.getOperations(device), (String)",");
            result.setOperations(opString);
        }
        catch (ApplicationException applicationException) {
            // empty catch block
        }
        return result;
    }

    public String getOperations() {
        return this.operations;
    }

    public String getType() {
        return this.type;
    }

    public void setOperations(String operations) {
        this.operations = operations;
    }

    public void setType(String type) {
        this.type = type;
    }
}

