/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.cloudsuite.gears.devicecontrol.service;

import de.intarsys.cloudsuite.gears.core.service.common.api.FlowOptions;
import de.intarsys.cloudsuite.gears.core.service.common.api.IOptionSupport;
import de.intarsys.cloudsuite.gears.core.service.common.impl.SvcCommon;
import de.intarsys.cloudsuite.gears.devicecontrol.backend.CtrlDevice;
import de.intarsys.cloudsuite.gears.devicecontrol.service.DtoCredential;
import de.intarsys.cloudsuite.gears.devicecontrol.service.DtoDevice;
import de.intarsys.cloudsuite.gears.devicecontrol.service.DtoDeviceProvider;
import de.intarsys.cloudsuite.gears.devicecontrol.service.DtoPrincipal;
import de.intarsys.cloudsuite.gears.devicecontrol.service.FlowCreatePrincipal;
import de.intarsys.cloudsuite.gears.devicecontrol.service.RequestAddFilterExpression;
import de.intarsys.cloudsuite.gears.devicecontrol.service.RequestAddFilterPrincipal;
import de.intarsys.cloudsuite.gears.devicecontrol.service.RequestControl;
import de.intarsys.cloudsuite.gears.devicecontrol.service.RequestEditPoolProperties;
import de.intarsys.cloudsuite.gears.devicecontrol.service.RequestPinCacheClear;
import de.intarsys.cloudsuite.gears.devicecontrol.service.RequestPinCacheSet;
import de.intarsys.cloudsuite.gears.devicecontrol.service.RequestPrincipalCreate;
import de.intarsys.cloudsuite.gears.devicecontrol.service.RequestRemoveFilterIndex;
import de.intarsys.cloudsuite.gears.devicecontrol.service.ResultDevice;
import de.intarsys.conversation.service.client.api.ConversationalResponse;
import de.intarsys.conversation.service.client.api.IntegrationOptions;
import de.intarsys.security.certificate.IX509PublicKeyCertificate;
import de.intarsys.security.device.ICredential;
import de.intarsys.security.device.IDevice;
import de.intarsys.security.device.IDeviceProvider;
import de.intarsys.security.device.IPrincipal;
import de.intarsys.tools.concurrent.SynchronousExecutorService;
import de.intarsys.tools.conversation.Conversational;
import de.intarsys.tools.conversation.IConversation;
import de.intarsys.tools.conversation.impl.Conversation;
import de.intarsys.tools.conversation.impl.MonitorConversation;
import de.intarsys.tools.conversation.service.impl.ConversationServiceTools;
import de.intarsys.tools.crypto.Secret;
import de.intarsys.tools.file.PathTools;
import de.intarsys.tools.jaxrs.ServiceImplementor;
import de.intarsys.tools.jaxrs.Stateful;
import de.intarsys.tools.loadbalance.LoadBalanced;
import de.intarsys.tools.logging.slf4j.Slf4jTools;
import jakarta.ws.rs.Consumes;
import jakarta.ws.rs.DELETE;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.POST;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.PathParam;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.core.Response;
import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Path(value="/v1/control/device")
@Component
@ServiceImplementor
public class SvcDevice
extends SvcCommon<ResultDevice> {
    @Autowired
    private CtrlDevice ctrlDevice;

    protected FlowCreatePrincipal createFlow(RequestPrincipalCreate request) {
        FlowCreatePrincipal flow = new FlowCreatePrincipal();
        ExecutorService tmpExecutor = FlowOptions.isAsynch((IOptionSupport)request) ? executor : new SynchronousExecutorService();
        MonitorConversation r = new MonitorConversation("monitor", tmpExecutor);
        r.exceptionally(ex -> {
            flow.dispose();
            throw Conversation.rethrowable((Throwable)ex);
        });
        flow.setConversation((IConversation)r);
        Slf4jTools.addCorrelation(null, (String)flow.getId());
        return flow;
    }

    @POST
    @Path(value="/deviceProviders/{poolDeviceProviderId}/devices/{poolDeviceId}/addFilterExpression")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public DtoDevice doAddFilterEpression(@PathParam(value="poolDeviceProviderId") String poolDeviceProviderId, @PathParam(value="poolDeviceId") String poolDeviceId, RequestAddFilterExpression request) throws Exception {
        IDevice device = this.ctrlDevice.addFilterExpression(poolDeviceProviderId, poolDeviceId, request.getExpression());
        return DtoDevice.create(device);
    }

    @POST
    @Path(value="/deviceProviders/{poolDeviceProviderId}/devices/{poolDeviceId}/addFilterPrincipal")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public DtoDevice doAddFilterPrincipal(@PathParam(value="poolDeviceProviderId") String poolDeviceProviderId, @PathParam(value="poolDeviceId") String poolDeviceId, RequestAddFilterPrincipal request) throws Exception {
        IDevice device = this.ctrlDevice.addFilterPrincipal(poolDeviceProviderId, poolDeviceId, request.getDeviceProvider(), request.getDevice(), request.getPrincipal());
        return DtoDevice.create(device);
    }

    @POST
    @Path(value="/deviceProviders/{deviceProviderId}/devices/{deviceId}/control")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public DtoDevice doControl(@PathParam(value="deviceProviderId") String deviceProviderId, @PathParam(value="deviceId") String deviceId, RequestControl request) throws Exception {
        IDevice device = this.ctrlDevice.control(deviceProviderId, deviceId, request.getCommand());
        return DtoDevice.create(device);
    }

    @Conversational
    @LoadBalanced
    @Stateful(role=Stateful.Role.Producer)
    @POST
    @Path(value="/deviceProviders/{deviceProviderId}/devices/{deviceId}/createPrincipal")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public ConversationalResponse doCreatePrincipal(@PathParam(value="deviceProviderId") String deviceProviderId, @PathParam(value="deviceId") String deviceId, RequestPrincipalCreate request) {
        FlowCreatePrincipal flow = this.createFlow(request);
        try {
            this.validateRequest(request);
            flow.setOptions(request.getArgs());
            IntegrationOptions integrationOptions = FlowOptions.getIntegrationOptions((IOptionSupport)flow);
            ConversationServiceTools.setRootConversation(flow.getConversation());
            ConversationServiceTools.setIntegrationOptions(flow.getConversation(), (IntegrationOptions)integrationOptions);
            flow.getConversation().monitor(() -> this.ctrlDevice.createPrincipal(deviceProviderId, deviceId, request.getArgs()).thenApply(p -> DtoPrincipal.create(p)));
        }
        catch (Exception e) {
            flow.getConversation().completeExceptionally((Throwable)e);
        }
        this.getConversationRegistry().publish(flow.getConversation());
        ConversationalResponse conversationalResponse = new ConversationalResponse();
        this.finishRequest(conversationalResponse, flow.getConversation());
        return conversationalResponse;
    }

    @POST
    @Path(value="/deviceProviders/{poolDeviceProviderId}/devices/{poolDeviceId}/editPoolProperties")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public DtoDevice doEditPoolProperties(@PathParam(value="poolDeviceProviderId") String poolDeviceProviderId, @PathParam(value="poolDeviceId") String poolDeviceId, RequestEditPoolProperties request) throws Exception {
        IDevice device = this.ctrlDevice.editPoolProperties(poolDeviceProviderId, poolDeviceId, request.isAutoStart(), request.getTimeout());
        return DtoDevice.create(device);
    }

    @POST
    @Path(value="/deviceProviders/{deviceProviderId}/devices/{deviceId}/principals/{principalId}/pinCacheClear")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public void doPinCacheClear(@PathParam(value="deviceProviderId") String deviceProviderId, @PathParam(value="deviceId") String deviceId, @PathParam(value="principalId") String principalId, RequestPinCacheClear request) throws Exception {
        this.ctrlDevice.pinCacheClear(deviceProviderId, deviceId, principalId);
    }

    @POST
    @Path(value="/deviceProviders/{deviceProviderId}/devices/{deviceId}/principals/{principalId}/pinCacheSet")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public void doPinCacheSet(@PathParam(value="deviceProviderId") String deviceProviderId, @PathParam(value="deviceId") String deviceId, @PathParam(value="principalId") String principalId, RequestPinCacheSet request) throws Exception {
        this.ctrlDevice.pinCacheSet(deviceProviderId, deviceId, principalId, Secret.hide((char[])request.getPin().toCharArray()), request.isStore());
    }

    @POST
    @Path(value="/deviceProviders/{poolDeviceProviderId}/devices/{poolDeviceId}/removeFilterIndex")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public DtoDevice doRemoveFilterIndex(@PathParam(value="poolDeviceProviderId") String poolDeviceProviderId, @PathParam(value="poolDeviceId") String poolDeviceId, RequestRemoveFilterIndex request) throws Exception {
        IDevice device = this.ctrlDevice.removeFilterIndex(poolDeviceProviderId, poolDeviceId, request.getIndex());
        return DtoDevice.create(device);
    }

    @DELETE
    @Path(value="/deviceProviders/{deviceProviderId}/devices/{deviceId}/principals/{principalId}")
    @Produces(value={"application/json"})
    public DtoPrincipal doRemovePrincipal(@PathParam(value="deviceProviderId") String deviceProviderId, @PathParam(value="deviceId") String deviceId, @PathParam(value="principalId") String principalId) throws Exception {
        IPrincipal beResult = this.ctrlDevice.removePrincipal(deviceProviderId, deviceId, principalId);
        return DtoPrincipal.create(beResult);
    }

    @GET
    @Path(value="/deviceProviders/{deviceProviderId}/devices/{deviceId}/credentials")
    @Produces(value={"application/json"})
    public List<DtoCredential> getCredentials(@PathParam(value="deviceProviderId") String deviceProviderId, @PathParam(value="deviceId") String deviceId) throws Exception {
        List<ICredential> beResult = this.ctrlDevice.getCredentials(deviceProviderId, deviceId);
        return beResult.stream().map(o -> DtoCredential.create(o)).sorted((o1, o2) -> o1.getLabel().compareToIgnoreCase(o2.getLabel())).collect(Collectors.toList());
    }

    @GET
    @Path(value="/deviceProviders/{deviceProviderId}")
    @Produces(value={"application/json"})
    public DtoDeviceProvider getDeviceProvider(@PathParam(value="deviceProviderId") String deviceProviderId) throws Exception {
        IDeviceProvider<?> beResult = this.ctrlDevice.getDeviceProvider(deviceProviderId);
        return DtoDeviceProvider.create(beResult);
    }

    @GET
    @Path(value="/deviceProviders")
    @Produces(value={"application/json"})
    public List<DtoDeviceProvider> getDeviceProviders() throws Exception {
        List<IDeviceProvider<?>> beResult = this.ctrlDevice.getDeviceProviders();
        return beResult.stream().map(o -> DtoDeviceProvider.create(o)).sorted((o1, o2) -> o1.getLabel().compareToIgnoreCase(o2.getLabel())).collect(Collectors.toList());
    }

    @GET
    @Path(value="/deviceProviders/{deviceProviderId}/devices/{deviceId}/principals/{principalId}")
    @Produces(value={"application/json"})
    public DtoPrincipal getPrincipal(@PathParam(value="deviceProviderId") String deviceProviderId, @PathParam(value="deviceId") String deviceId, @PathParam(value="principalId") String principalId) throws Exception {
        IPrincipal beResult = this.ctrlDevice.getPrincipal(deviceProviderId, deviceId, principalId);
        return DtoPrincipal.create(beResult);
    }

    @GET
    @Path(value="/deviceProviders/{deviceProviderId}/devices/{deviceId}/principals/{principalId}/certificate")
    public Response getPrincipalCertificate(@PathParam(value="deviceProviderId") String deviceProviderId, @PathParam(value="deviceId") String deviceId, @PathParam(value="principalId") String principalId) throws Exception {
        IX509PublicKeyCertificate certificate = this.ctrlDevice.getPrincipalCertificate(deviceProviderId, deviceId, principalId);
        if (certificate == null) {
            // empty if block
        }
        String filename = PathTools.getName((String)(principalId + ".cer"));
        return Response.ok((Object)certificate.getEncoded()).header("Content-type", (Object)"application/octet-stream").header("Content-Disposition", (Object)("attachment; filename=\"" + filename + "\"")).build();
    }

    @GET
    @Path(value="/deviceProviders/{deviceProviderId}/devices/{deviceId}/principals")
    @Produces(value={"application/json"})
    public List<DtoPrincipal> getPrincipals(@PathParam(value="deviceProviderId") String deviceProviderId, @PathParam(value="deviceId") String deviceId) throws Exception {
        List<IPrincipal> beResult = this.ctrlDevice.getPrincipals(deviceProviderId, deviceId);
        return beResult.stream().map(o -> DtoPrincipal.create(o)).sorted((o1, o2) -> o1.getLabel().compareToIgnoreCase(o2.getLabel())).collect(Collectors.toList());
    }

    protected void validateRequest(RequestPrincipalCreate request) {
        if (request == null) {
            throw new IllegalArgumentException("request can not be empty");
        }
    }
}

