/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.cloudsuite.gears.document.type.pdf;

import de.intarsys.tools.crypto.api.ICipherFactory;
import de.intarsys.tools.crypto.standard.EncryptedLocator;
import de.intarsys.tools.crypto.standard.JcaCipherFactory;
import de.intarsys.tools.file.FileTools;
import de.intarsys.tools.locator.ByteArrayLocator;
import de.intarsys.tools.locator.FileLocator;
import de.intarsys.tools.locator.ILocator;
import de.intarsys.tools.locator.ITransientLocatorFactory;
import java.io.File;
import java.io.IOException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EncryptedTransientLocatorFactory
implements ITransientLocatorFactory {
    private static final int DEFAULT_BUFFER_SIZE = 0xA00000;
    private static final Logger Log = LoggerFactory.getLogger(EncryptedTransientLocatorFactory.class);
    private long maxBufferSize = 0xA00000L;

    protected ICipherFactory createCipherFactory() {
        JcaCipherFactory factory = new JcaCipherFactory();
        factory.setEncryptionAlgorithmTransformation("AES/CTR/NoPadding");
        return factory;
    }

    public ILocator createLocator(ILocator locator) throws IOException {
        long size = locator.getLength();
        String name = locator.getName();
        if (size >= 0L && size < this.getMaxBufferSize()) {
            return new ByteArrayLocator(new byte[(int)size], 0, name);
        }
        File tempFile = FileTools.createTempFile((String)name);
        FileLocator baseLocator = new FileLocator(tempFile);
        Log.trace("create encrypted transient locator at '{}'", (Object)tempFile);
        EncryptedLocator encryptedLocator = new EncryptedLocator((ILocator)baseLocator, this.createCipherFactory());
        return encryptedLocator;
    }

    public long getMaxBufferSize() {
        return this.maxBufferSize;
    }

    public void setMaxBufferSize(long maxBufferSize) {
        this.maxBufferSize = maxBufferSize;
    }
}

