/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.cloudsuite.gears.filter.common;

import de.intarsys.tools.zones.IZone;
import de.intarsys.tools.zones.Zone;
import de.intarsys.tools.zones.ZoneSpec;
import jakarta.annotation.Priority;
import jakarta.ws.rs.container.ContainerRequestContext;
import jakarta.ws.rs.container.ContainerRequestFilter;
import jakarta.ws.rs.container.ContainerResponseContext;
import jakarta.ws.rs.container.ContainerResponseFilter;
import jakarta.ws.rs.ext.Provider;
import java.io.IOException;

@Provider
@Priority(value=900)
public class ZoneFilter
implements ContainerRequestFilter,
ContainerResponseFilter {
    private static final String PROPERTY_NAME = IZone.class.getName();
    public static final int PRIORITY = 900;
    private static final IZone WEBZONE = Zone.getRoot().fork(ZoneSpec.with((String)"web-request"));

    public void filter(ContainerRequestContext requestContext) throws IOException {
        WEBZONE.enter();
        requestContext.setProperty(PROPERTY_NAME, (Object)WEBZONE);
    }

    public void filter(ContainerRequestContext requestContext, ContainerResponseContext responseContext) throws IOException {
        IZone webZone = (IZone)requestContext.getProperty(PROPERTY_NAME);
        if (webZone != null) {
            requestContext.removeProperty(PROPERTY_NAME);
            webZone.leave();
        }
    }
}

