/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.cloudsuite.gears.license.service;

import de.intarsys.tools.license.License;
import de.intarsys.tools.license.LicenseEnvironment;

public class DtoLicense {
    private String productId;
    private String version;
    private String state;
    private String properties;
    private String from;
    private String to;
    private String type;
    private Integer quantity;
    private String installKey;

    public static DtoLicense create(License value) {
        if (value == null) {
            return null;
        }
        DtoLicense dtoLicense = new DtoLicense();
        dtoLicense.setProductId(value.getProductId());
        dtoLicense.setVersion(value.getProductVersion());
        dtoLicense.setState(value.getStateString(LicenseEnvironment.get().lookupProduct(value.getProductId())));
        dtoLicense.setProperties(value.getPropertiesString());
        dtoLicense.setFrom(value.getValidFromString());
        dtoLicense.setTo(value.getValidToString());
        dtoLicense.setType(value.getType());
        dtoLicense.setQuantity(value.getQuantity());
        dtoLicense.setInstallKey(value.getOwnerKey());
        return dtoLicense;
    }

    public String getFrom() {
        return this.from;
    }

    public String getInstallKey() {
        return this.installKey;
    }

    public String getProductId() {
        return this.productId;
    }

    public String getProperties() {
        return this.properties;
    }

    public Integer getQuantity() {
        return this.quantity;
    }

    public String getState() {
        return this.state;
    }

    public String getTo() {
        return this.to;
    }

    public String getType() {
        return this.type;
    }

    public String getVersion() {
        return this.version;
    }

    public void setFrom(String from) {
        this.from = from;
    }

    public void setInstallKey(String installKey) {
        this.installKey = installKey;
    }

    public void setProductId(String productId) {
        this.productId = productId;
    }

    public void setProperties(String properties) {
        this.properties = properties;
    }

    public void setQuantity(Integer quantity) {
        this.quantity = quantity;
    }

    public void setState(String state) {
        this.state = state;
    }

    public void setTo(String to) {
        this.to = to;
    }

    public void setType(String type) {
        this.type = type;
    }

    public void setVersion(String version) {
        this.version = version;
    }
}

