/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.cloudsuite.gears.license.service;

import de.intarsys.tools.license.ILicenseAccount;
import de.intarsys.tools.license.LicenseProperty;
import java.text.NumberFormat;
import java.time.Instant;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.time.format.FormatStyle;

public class DtoLicenseAccount {
    private String name;
    private String id;
    private String available;
    private String restriction;
    private String nextReset;

    public static DtoLicenseAccount create(ILicenseAccount account) {
        if (account == null) {
            return null;
        }
        DtoLicenseAccount dtoLicenseAccount = new DtoLicenseAccount();
        dtoLicenseAccount.setName(account.toString());
        LicenseProperty property = account.getLicenseProperty();
        dtoLicenseAccount.setId(property.getQualifiedName());
        dtoLicenseAccount.setRestriction(property.getValueUnitString());
        DtoLicenseAccount.setLicenseAccountsLimit(account, property, dtoLicenseAccount);
        DtoLicenseAccount.setLicenseAccountsNextReset(account, property, dtoLicenseAccount);
        return dtoLicenseAccount;
    }

    private static void setLicenseAccountsLimit(ILicenseAccount account, LicenseProperty property, DtoLicenseAccount dtoLicenseAccount) {
        if (account.getLimit() == -1) {
            dtoLicenseAccount.setAvailable("unlimited");
        } else {
            dtoLicenseAccount.setAvailable(NumberFormat.getInstance().format(account.getBalance()));
        }
    }

    private static void setLicenseAccountsNextReset(ILicenseAccount account, LicenseProperty property, DtoLicenseAccount dtoLicenseAccount) {
        Instant nextReset = account.getNextReset();
        if (nextReset == null) {
            dtoLicenseAccount.setNextReset("");
        } else if (nextReset.isBefore(Instant.now())) {
            dtoLicenseAccount.setNextReset("at next access");
        } else {
            DateTimeFormatter.ofLocalizedDateTime(FormatStyle.SHORT).format(nextReset.atZone(ZoneId.systemDefault()));
        }
    }

    public String getAvailable() {
        return this.available;
    }

    public String getId() {
        return this.id;
    }

    public String getName() {
        return this.name;
    }

    public String getNextReset() {
        return this.nextReset;
    }

    public String getRestriction() {
        return this.restriction;
    }

    public void setAvailable(String available) {
        this.available = available;
    }

    public void setId(String id) {
        this.id = id;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setNextReset(String nextReset) {
        this.nextReset = nextReset;
    }

    public void setRestriction(String restriction) {
        this.restriction = restriction;
    }
}

