/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.cloudsuite.gears.license.service;

import de.intarsys.cloudsuite.gears.license.backend.CtrlLicense;
import de.intarsys.cloudsuite.gears.license.service.DtoLicense;
import de.intarsys.cloudsuite.gears.license.service.DtoLicenseAccount;
import de.intarsys.tools.jaxrs.ServiceImplementor;
import de.intarsys.tools.license.ILicenseAccount;
import de.intarsys.tools.license.License;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.Produces;
import java.util.List;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Path(value="/v1/control/license")
@Component
@ServiceImplementor
public class SvcLicense {
    @Autowired
    private CtrlLicense ctrlLicense;

    @GET
    @Path(value="/licenseAccounts")
    @Produces(value={"application/json"})
    public List<DtoLicenseAccount> getLicenseAccount() throws Exception {
        List<? extends ILicenseAccount> licenseAccount = this.ctrlLicense.getLicenseAccounts();
        return licenseAccount.stream().map(o -> DtoLicenseAccount.create(o)).collect(Collectors.toList());
    }

    @GET
    @Path(value="/licenses")
    @Produces(value={"application/json"})
    public List<DtoLicense> getLicenses() throws Exception {
        List<License> licenses = this.ctrlLicense.getLicenses();
        return licenses.stream().map(o -> DtoLicense.create(o)).collect(Collectors.toList());
    }
}

