/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.cloudsuite.gears.model.entity.certificate;

import de.intarsys.cloudsuite.gears.model.entity.certificate.IX509CertificateDao;
import de.intarsys.cloudsuite.gears.model.entity.certificate.X509CertificateLookupKey;
import de.intarsys.security.certificate.IX509PublicKeyCertificate;
import de.intarsys.security.certificate.filter.IX509CertificateFilter;
import de.intarsys.security.certificate.filter.standard.X509CertificateSelector;
import de.intarsys.security.certificate.provider.ICertificateProvider;
import de.intarsys.security.certificate.provider.keystore.IKeyStore;
import de.intarsys.security.certificate.provider.keystore.KeyStoreFactory;
import de.intarsys.tools.crypto.Secret;
import de.intarsys.tools.crypto.api.IByteProvider;
import de.intarsys.tools.locator.FileLocator;
import de.intarsys.tools.locator.ILocator;
import jakarta.annotation.PostConstruct;
import java.io.IOException;
import java.math.BigInteger;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.Iterator;
import javax.security.auth.x500.X500Principal;

public class FooKeyStoreX509CertificateDao
implements IX509CertificateDao {
    private IByteProvider keyStoreKeyProvider;
    private String keyStoreFileName;
    private IKeyStore keyStore;

    public X509Certificate getCertificate(X500Principal issuer, BigInteger serial) throws IOException {
        ICertificateProvider provider = this.keyStore.getCertificateProvider();
        X509CertificateSelector selector = new X509CertificateSelector();
        selector.setIssuer(issuer);
        selector.setSerialNumber(serial);
        Iterator i = provider.lookupCertificates((IX509CertificateFilter)selector);
        if (!i.hasNext()) {
            throw new IOException("not found");
        }
        try {
            return ((IX509PublicKeyCertificate)i.next()).toJavaCertificate();
        }
        catch (CertificateException e) {
            throw new IOException(e);
        }
    }

    public String getKeyStoreFileName() {
        return this.keyStoreFileName;
    }

    public IByteProvider getKeyStoreKeyProvider() {
        return this.keyStoreKeyProvider;
    }

    @PostConstruct
    public void init() {
        try {
            FileLocator locator = new FileLocator(this.getKeyStoreFileName());
            this.keyStore = KeyStoreFactory.get().create((ILocator)locator);
            Secret keyStoreSecret = Secret.hide((byte[])this.getKeyStoreKeyProvider().getBytes());
            this.keyStore.load(keyStoreSecret);
        }
        catch (Exception e) {
            throw new IllegalArgumentException("cannot load keystore", e);
        }
    }

    public X509Certificate lookupItem(Object key) throws IOException {
        X509CertificateLookupKey x509key = (X509CertificateLookupKey)key;
        return this.getCertificate(x509key.getIssuer(), x509key.getSerial());
    }

    public void setKeyStoreFileName(String value) {
        this.keyStoreFileName = value;
    }

    public void setKeyStoreKeyProvider(IByteProvider value) {
        this.keyStoreKeyProvider = value;
    }
}

