/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.cloudsuite.gears.password.service;

import de.intarsys.cloudsuite.gears.password.backend.CtrlPassword;
import de.intarsys.cloudsuite.gears.password.service.DtoCryptDec;
import de.intarsys.cloudsuite.gears.password.service.DtoEncryptedValue;
import de.intarsys.cloudsuite.gears.password.service.RequestEncrypt;
import de.intarsys.tools.crypto.ICryptdecFactory;
import de.intarsys.tools.crypto.Secret;
import de.intarsys.tools.jaxrs.ServiceImplementor;
import jakarta.ws.rs.Consumes;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.POST;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.Produces;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Path(value="/v1/control/password")
@Component
@ServiceImplementor
public class SvcPassword {
    @Autowired
    private CtrlPassword ctrlPassword;

    @POST
    @Path(value="/cryptdecs/encrypt")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public DtoEncryptedValue doEncrypt(RequestEncrypt request) throws Exception {
        Secret encryptedValue = this.ctrlPassword.encrypt(request.getCryptDec(), request.getPlainValue());
        return DtoEncryptedValue.create(encryptedValue.getEncoded());
    }

    @GET
    @Path(value="/cryptdecs")
    @Produces(value={"application/json"})
    public List<DtoCryptDec> getCryptDecs() throws Exception {
        Collection<ICryptdecFactory> passwordDecs = this.ctrlPassword.getCryptDecs();
        return passwordDecs.stream().map(o -> DtoCryptDec.create(o)).collect(Collectors.toList());
    }
}

