/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.cloudsuite.gears.security.spring;

import de.intarsys.cloudsuite.gears.model.entity.principal.ClaimValueConverter;
import de.intarsys.cloudsuite.gears.model.entity.principal.GenericClaim;
import de.intarsys.cloudsuite.gears.model.entity.principal.GenericPrincipal;
import de.intarsys.cloudsuite.gears.model.entity.principal.IClaim;
import de.intarsys.cloudsuite.gears.model.entity.principal.IPrincipal;
import de.intarsys.cloudsuite.gears.model.entity.principal.IPrincipalDao;
import de.intarsys.cloudsuite.gears.model.persistence.common.CommonEntityDao;
import java.io.IOException;
import java.util.Map;
import org.springframework.security.oauth2.server.resource.authentication.AbstractOAuth2TokenAuthenticationToken;

public class JwtPrincipalDao
extends CommonEntityDao<IPrincipal>
implements IPrincipalDao {
    public IPrincipal lookupItem(Object key) throws IOException {
        if (!(key instanceof AbstractOAuth2TokenAuthenticationToken)) {
            throw new IllegalArgumentException("spring JWT based authentication required");
        }
        AbstractOAuth2TokenAuthenticationToken auth = (AbstractOAuth2TokenAuthenticationToken)key;
        GenericPrincipal principal = new GenericPrincipal();
        principal.setName(auth.getName());
        Map tokenAttributes = auth.getTokenAttributes();
        for (Map.Entry entry : tokenAttributes.entrySet()) {
            GenericClaim claim = new GenericClaim((String)entry.getKey(), ClaimValueConverter.convertObject(entry.getValue()));
            principal.addClaim((IClaim)claim);
        }
        return principal;
    }
}

