/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.cloudsuite.gears.security.spring;

import de.intarsys.cloudsuite.gears.core.service.common.api.IOptionSupport;
import de.intarsys.cloudsuite.gears.model.entity.principal.IPrincipal;
import de.intarsys.cloudsuite.gears.model.entity.principal.IPrincipalDao;
import de.intarsys.cloudsuite.gears.model.entity.principal.IPrincipalProvider;
import de.intarsys.cloudsuite.gears.model.persistence.common.IKeyConverter;
import de.intarsys.tools.string.StringTools;
import jakarta.annotation.PostConstruct;
import java.io.IOException;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.context.SecurityContextHolder;

public class SpringSecurityPrincipalProvider
implements IPrincipalProvider {
    private String role;
    private IPrincipalDao principalDao;
    private IKeyConverter keyConverter;

    public void enter(IOptionSupport optionSupport) {
    }

    public IKeyConverter getKeyConverter() {
        return this.keyConverter;
    }

    public IPrincipal getPrincipal() {
        Authentication authentication = SecurityContextHolder.getContext().getAuthentication();
        if (authentication != null && authentication.isAuthenticated()) {
            try {
                Authentication key = this.getKeyConverter() == null ? authentication : this.getKeyConverter().convert((Object)authentication);
                return (IPrincipal)this.getPrincipalDao().lookupItem((Object)key);
            }
            catch (IOException e) {
                throw new IllegalArgumentException("principal lookup failed", e);
            }
        }
        return null;
    }

    public IPrincipalDao getPrincipalDao() {
        return this.principalDao;
    }

    public String getRole() {
        return this.role;
    }

    @PostConstruct
    public void init() {
        if (this.getPrincipalDao() == null) {
            throw new IllegalArgumentException("principalDao required");
        }
        if (StringTools.isEmpty((String)this.getRole())) {
            throw new IllegalArgumentException("role required");
        }
    }

    public void leave() {
    }

    public void setKeyConverter(IKeyConverter keyConverter) {
        this.keyConverter = keyConverter;
    }

    public void setPrincipalDao(IPrincipalDao principalDao) {
        this.principalDao = principalDao;
    }

    public void setRole(String role) {
        this.role = role;
    }
}

