/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.document.aspect;

import de.intarsys.document.aspect.IAspect;
import de.intarsys.document.aspect.IAspectDispatcher;
import de.intarsys.document.aspect.IAspectProvider;
import de.intarsys.document.aspect.IAspectType;
import de.intarsys.document.aspect.common.NoAspectProvider;
import de.intarsys.document.aspect.type.common.NoAspectType;
import de.intarsys.document.model.IDocument;
import de.intarsys.tools.exception.ExceptionTools;
import de.intarsys.tools.exception.InitializationException;
import de.intarsys.tools.functor.Args;
import de.intarsys.tools.functor.IArgs;
import de.intarsys.tools.objectmodel.FunctorMethod;
import de.intarsys.tools.objectmodel.IClassSelector;
import de.intarsys.tools.objectmodel.IMethod;
import de.intarsys.tools.objectmodel.ObjectModelTools;
import de.intarsys.tools.reflect.MethodException;
import de.intarsys.tools.reflect.MethodNotFoundException;
import de.intarsys.tools.reflect.ObjectCreationException;
import jakarta.annotation.PostConstruct;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;

public class AspectEnvironment
implements IAspectDispatcher {
    @Autowired(required=false)
    private List<IAspectProvider> aspectProviders;
    private NoAspectProvider noAspectProvider = new NoAspectProvider(NoAspectType.TYPE);
    @Autowired(required=false)
    private List<IAspectType> aspectTypes;

    protected String createMethodName(IAspectType type) {
        return type.getClass().getName().replace('.', '_');
    }

    @Override
    public IAspect getAspect(IAspectType type, IDocument document, IArgs args) throws ObjectCreationException {
        try {
            IAspectProvider provider = (IAspectProvider)document.invoke(this.createMethodName(type), (IArgs)Args.create());
            return provider.getAspect(document, args);
        }
        catch (MethodNotFoundException e) {
            return this.noAspectProvider.getAspect(document, args);
        }
        catch (MethodException e) {
            throw new ObjectCreationException(ExceptionTools.unwrap((Throwable)e));
        }
    }

    public List<IAspectProvider> getAspectProviders() {
        return this.aspectProviders;
    }

    public IAspectType getAspectType(String id) {
        for (IAspectType type : this.getAspectTypes()) {
            if (!type.getId().equals(id)) continue;
            return type;
        }
        return NoAspectType.TYPE;
    }

    public List<IAspectType> getAspectTypes() {
        return this.aspectTypes;
    }

    @PostConstruct
    public void install() {
        try {
            for (IAspectProvider provider : this.getAspectProviders()) {
                IClassSelector selector = ObjectModelTools.createSelector((String)provider.getDocumentClass().getName());
                FunctorMethod method = new FunctorMethod(this.createMethodName(provider.getType()), call -> provider);
                method.setDeclaringClass(ObjectModelTools.lookupClass((IClassSelector)selector));
                ObjectModelTools.registerMethod((IClassSelector)selector, (IMethod)method);
            }
        }
        catch (ObjectCreationException e) {
            throw new InitializationException((Throwable)e);
        }
    }

    public void setAspectProviders(List<IAspectProvider> aspectProviders) {
        this.aspectProviders = aspectProviders;
    }

    public void setAspectTypes(List<IAspectType> aspectTypes) {
        this.aspectTypes = aspectTypes;
    }
}

