/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.document.aspect.document.image.print;

import de.intarsys.document.aspect.IAspect;
import de.intarsys.document.aspect.document.image.common.ImageAspectProvider;
import de.intarsys.document.model.IDocument;
import de.intarsys.documents.aspect.type.printer.PrinterAspectType;
import de.intarsys.pdf.app.image.PDImageFactory;
import de.intarsys.pdf.cds.CDSMatrix;
import de.intarsys.pdf.cds.CDSRectangle;
import de.intarsys.pdf.content.IContentStreamProvider;
import de.intarsys.pdf.content.common.CSCreator;
import de.intarsys.pdf.pd.PDImage;
import de.intarsys.pdf.pd.PDPage;
import de.intarsys.pdf.pd.PDXObject;
import de.intarsys.tools.enumeration.common.EnumScaleWhen;
import de.intarsys.tools.functor.IArgs;
import de.intarsys.tools.locator.ILocator;
import de.intarsys.tools.locator.LocatorTools;
import de.intarsys.tools.reflect.ObjectCreationException;
import java.awt.image.BufferedImage;
import java.io.IOException;
import javax.imageio.ImageReader;
import org.springframework.beans.factory.annotation.Autowired;

public class PrintAspectProvider
extends ImageAspectProvider {
    private static final String JPEG_FORMAT_NAME = "jpeg";
    public static final float DEFAULT_COMPRESSIONQUALITY = 0.75f;
    private static final int MAX_INCREMENTAL_SAVE_COUNT = 100;
    private static final int DEFAULT_IMAGES_PER_SAVEPOINT = 50;
    private static final int SCALE_FACTOR = 1;
    public static final String PDF = "pdf";
    private int imagesPerSavepoint = 50;

    protected PrintAspectProvider(@Autowired PrinterAspectType type) {
        super(type);
    }

    protected CDSMatrix fit(PDImage image, CDSRectangle destRect, EnumScaleWhen scaleWhen) {
        float destWidth = destRect.getWidth();
        float destHeight = destRect.getHeight();
        float imageWidth = image.getWidth();
        float imageHeight = image.getHeight();
        float scaleX = destWidth / imageWidth;
        float scaleY = destHeight / imageHeight;
        if (scaleWhen != EnumScaleWhen.ALWAYS) {
            if (scaleWhen == EnumScaleWhen.NEVER) {
                scaleX = 1.0f;
                scaleY = 1.0f;
            } else if (scaleWhen == EnumScaleWhen.TOOBIG) {
                if (scaleX > 1.0f && scaleY > 1.0f) {
                    scaleX = 1.0f;
                    scaleY = 1.0f;
                }
            } else if (scaleWhen == EnumScaleWhen.TOOSMALL && scaleX <= 1.0f && scaleY <= 1.0f) {
                scaleX = 1.0f;
                scaleY = 1.0f;
            }
        }
        float scaledWidth = imageWidth * scaleX;
        float scaledHeight = imageHeight * scaleY;
        float offsetX = Math.max(0.0f, destWidth - scaledWidth) / 2.0f;
        float offsetY = 0.0f;
        CDSMatrix matrix = new CDSMatrix(1.0f, 0.0f, 0.0f, 1.0f, 0.0f, 0.0f);
        matrix.translate(destRect.getLowerLeftX(), destRect.getLowerLeftY());
        matrix.translate(offsetX, offsetY);
        matrix.scale((float)image.getWidth(), (float)image.getHeight());
        matrix.scale(new float[]{scaleX, scaleY});
        return matrix;
    }

    /*
     * Exception decompiling
     */
    @Override
    public IAspect getAspect(IDocument document, IArgs args) throws ObjectCreationException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 3 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    protected void insertImage(PDPage page, PDImage pdImage) {
        CDSRectangle pageRect = new CDSRectangle(0.0f, 0.0f, (float)(pdImage.getWidth() * 1), (float)(pdImage.getHeight() * 1));
        page.setMediaBox(pageRect);
        EnumScaleWhen scaleWhen = EnumScaleWhen.ALWAYS;
        CSCreator creator = CSCreator.createNew((IContentStreamProvider)page);
        creator.saveState();
        CDSMatrix fit = this.fit(pdImage, page.getMediaBox(), scaleWhen);
        creator.transform(fit.getA(), fit.getB(), fit.getC(), fit.getD(), fit.getE(), fit.getF());
        creator.doXObject(null, (PDXObject)pdImage);
        creator.restoreState();
        creator.close();
        page.addContentStream(creator.getContent());
    }

    private boolean isJpeg(ImageReader imageReader) throws IOException {
        return JPEG_FORMAT_NAME.equalsIgnoreCase(imageReader.getFormatName());
    }

    private PDImage readImage(ILocator locator, ImageReader imageReader, int imageIndex) throws IOException {
        PDImageFactory factory = new PDImageFactory();
        BufferedImage image = imageReader.read(imageIndex);
        boolean jpeg = this.isJpeg(imageReader);
        if (jpeg) {
            byte[] imageData = LocatorTools.getBytes((ILocator)locator);
            return factory.createPDImageFromJpeg(image, imageData);
        }
        return factory.createPDImage(image);
    }
}

