/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.document.aspect.document.image.rendering;

import de.intarsys.cwt.awt.image.IAwtImage;
import de.intarsys.cwt.image.IImageContainer;
import de.intarsys.cwt.image.IImageEntry;
import de.intarsys.cwt.image.ImageConvertOption;
import de.intarsys.document.aspect.IAspect;
import de.intarsys.document.aspect.document.image.common.ImageAspectProvider;
import de.intarsys.document.aspect.type.rendering.DocumentRenderingAspect;
import de.intarsys.document.aspect.type.rendering.DocumentRenderingAspectType;
import de.intarsys.document.aspect.type.rendering.RenderingParameters;
import de.intarsys.document.aspect.type.rendering.RenderingTools;
import de.intarsys.document.model.IDocument;
import de.intarsys.tools.functor.ArgTools;
import de.intarsys.tools.functor.IArgs;
import jakarta.ws.rs.InternalServerErrorException;
import org.springframework.beans.factory.annotation.Autowired;

public class DocumentRenderingAspectProvider
extends ImageAspectProvider {
    public DocumentRenderingAspectProvider(@Autowired DocumentRenderingAspectType type) {
        super(type);
    }

    protected void build() {
    }

    public byte[] createImage(IDocument document, int index, RenderingParameters renderParams) {
        IImageEntry imageEntry = this.getImageAt(document, index);
        if (imageEntry == null) {
            return null;
        }
        IAwtImage awtImage = (IAwtImage)imageEntry.asImage(IAwtImage.class, new ImageConvertOption[0]);
        return RenderingTools.writeImage(awtImage.getBufferedImage(), renderParams);
    }

    @Override
    public IAspect getAspect(IDocument document, IArgs args) {
        DocumentRenderingAspect aspect = new DocumentRenderingAspect(this.getType(), document);
        int index = ArgTools.getIntStrict((IArgs)args, (String)"pageIndex", (int)1);
        Object oRenderingParameters = ArgTools.getObject((IArgs)args, (String)"renderingParameters", null);
        RenderingParameters renderingParameters = oRenderingParameters instanceof RenderingParameters ? (RenderingParameters)oRenderingParameters : new RenderingParameters();
        aspect.setBytes(this.createImage(document, index, renderingParameters));
        aspect.setFormat(renderingParameters.getFormat());
        return aspect;
    }

    protected IImageEntry getImageAt(IDocument document, int index) {
        try {
            IImageContainer imageContainer = (IImageContainer)document.getImpl();
            if (imageContainer == null) {
                return null;
            }
            return imageContainer.getImageAt(index);
        }
        catch (Exception e) {
            throw new InternalServerErrorException("error reading document", (Throwable)e);
        }
    }
}

