/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.document.aspect.document.pdf.common;

import de.intarsys.document.aspect.IAspect;
import de.intarsys.document.aspect.document.pdf.common.PDFAspectProvider;
import de.intarsys.document.aspect.type.common.AdditionalPropertiesAspect;
import de.intarsys.document.aspect.type.common.AdditionalPropertiesAspectType;
import de.intarsys.document.model.IDocument;
import de.intarsys.document.type.pdf.PDFDocument;
import de.intarsys.pdf.pd.PDDocument;
import de.intarsys.tools.functor.IArgs;
import jakarta.ws.rs.InternalServerErrorException;
import org.springframework.beans.factory.annotation.Autowired;

public class AdditionalPropertiesAspectProvider
extends PDFAspectProvider {
    public AdditionalPropertiesAspectProvider(@Autowired AdditionalPropertiesAspectType type) {
        super(type);
    }

    protected void build(IDocument document, AdditionalPropertiesAspect aspect) {
        try {
            PDDocument pdDoc = (PDDocument)((PDFDocument)document).getImpl();
            aspect.getProperties().put("Author", pdDoc.getAuthor());
            aspect.getProperties().put("CreationDate", pdDoc.getCreationDateString());
            aspect.getProperties().put("Creator", pdDoc.getCreator());
            aspect.getProperties().put("Keywords", pdDoc.getKeywords());
            aspect.getProperties().put("ModDate", pdDoc.getModDateString());
            aspect.getProperties().put("Producer", pdDoc.getProducer());
            aspect.getProperties().put("Subject", pdDoc.getSubject());
            aspect.getProperties().put("Title", pdDoc.getTitle());
        }
        catch (Exception e) {
            throw new InternalServerErrorException("error reading PDF document", (Throwable)e);
        }
    }

    @Override
    public IAspect getAspect(IDocument document, IArgs args) {
        AdditionalPropertiesAspect aspect = new AdditionalPropertiesAspect(this.getType(), document);
        this.build(document, aspect);
        return aspect;
    }
}

