/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.document.aspect.document.pdf.common;

import de.intarsys.document.aspect.IAspect;
import de.intarsys.document.aspect.document.pdf.common.IAnnotationCollector;
import de.intarsys.document.aspect.document.pdf.common.PDFAspectProvider;
import de.intarsys.document.aspect.document.pdf.common.PdfAnnotationsCollector;
import de.intarsys.document.aspect.document.pdf.common.TagsAnnotationsCollector;
import de.intarsys.document.aspect.type.annotation.AnnotationsAspect;
import de.intarsys.document.aspect.type.annotation.AnnotationsAspectType;
import de.intarsys.document.model.IDocument;
import de.intarsys.tools.factory.FactoryTools;
import de.intarsys.tools.functor.IArgs;
import jakarta.ws.rs.InternalServerErrorException;
import java.util.ArrayList;
import org.springframework.beans.factory.annotation.Autowired;

public class AnnotationsAspectProvider
extends PDFAspectProvider {
    public AnnotationsAspectProvider(@Autowired AnnotationsAspectType type) {
        super(type);
    }

    protected void build(IDocument document, AnnotationsAspect aspect, IArgs args) {
        ArrayList<IAnnotationCollector> collectors = new ArrayList<IAnnotationCollector>();
        try {
            collectors.add((IAnnotationCollector)FactoryTools.createInstance(PdfAnnotationsCollector.class, (IArgs)args));
            collectors.add((IAnnotationCollector)FactoryTools.createInstance(TagsAnnotationsCollector.class, (IArgs)args));
            for (IAnnotationCollector collector : collectors) {
                collector.collect(document, aspect);
            }
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new InternalServerErrorException("error collecting annotations", (Throwable)e);
        }
    }

    @Override
    public IAspect getAspect(IDocument document, IArgs args) {
        AnnotationsAspect aspect = new AnnotationsAspect(this.getType(), document);
        this.build(document, aspect, args);
        return aspect;
    }
}

