/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.document.aspect.document.pdf.common;

import de.intarsys.document.aspect.IAspect;
import de.intarsys.document.aspect.document.pdf.common.PDFAspectProvider;
import de.intarsys.document.aspect.type.common.AttachmentsAspect;
import de.intarsys.document.aspect.type.common.AttachmentsAspectType;
import de.intarsys.document.aspect.type.common.DtoFile;
import de.intarsys.document.model.IDocument;
import de.intarsys.document.type.pdf.PDFDocument;
import de.intarsys.pdf.app.files.EmbeddedFile;
import de.intarsys.pdf.app.files.EmbeddedFiles;
import de.intarsys.pdf.pd.PDDocument;
import de.intarsys.tools.functor.IArgs;
import jakarta.ws.rs.InternalServerErrorException;
import org.springframework.beans.factory.annotation.Autowired;

public class AttachmentsAspectProvider
extends PDFAspectProvider {
    public AttachmentsAspectProvider(@Autowired AttachmentsAspectType type) {
        super(type);
    }

    protected void build(IDocument document, AttachmentsAspect aspect) {
        try {
            PDDocument pdDoc = (PDDocument)((PDFDocument)document).getImpl();
            EmbeddedFiles files = EmbeddedFiles.get((PDDocument)pdDoc);
            for (EmbeddedFile file : files.getFiles()) {
                DtoFile dtoFile = new DtoFile();
                dtoFile.setName(file.getLabel());
                aspect.addFile(dtoFile);
            }
        }
        catch (Exception e) {
            throw new InternalServerErrorException("error reading PDF document", (Throwable)e);
        }
    }

    @Override
    public IAspect getAspect(IDocument document, IArgs args) {
        AttachmentsAspect aspect = new AttachmentsAspect(this.getType(), document);
        this.build(document, aspect);
        return aspect;
    }
}

