/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.document.aspect.document.pdf.common;

import de.intarsys.document.aspect.IAspect;
import de.intarsys.document.aspect.document.pdf.common.PDFAspectProvider;
import de.intarsys.document.aspect.type.common.BasicPropertiesAspect;
import de.intarsys.document.aspect.type.common.BasicPropertiesAspectType;
import de.intarsys.document.model.IDocument;
import de.intarsys.document.type.pdf.PDFDocument;
import de.intarsys.pdf.pd.PDDocument;
import de.intarsys.tools.functor.IArgs;
import jakarta.ws.rs.InternalServerErrorException;
import org.springframework.beans.factory.annotation.Autowired;

public class BasicPropertiesAspectProvider
extends PDFAspectProvider {
    public BasicPropertiesAspectProvider(@Autowired BasicPropertiesAspectType type) {
        super(type);
    }

    protected void build(IDocument document, BasicPropertiesAspect aspect) {
        try {
            PDDocument pdDoc = (PDDocument)((PDFDocument)document).getImpl();
            aspect.setPageCount(pdDoc.getPageTree().getCount());
        }
        catch (Exception e) {
            throw new InternalServerErrorException("error reading PDF document", (Throwable)e);
        }
    }

    @Override
    public IAspect getAspect(IDocument document, IArgs args) {
        BasicPropertiesAspect aspect = new BasicPropertiesAspect(this.getType(), document);
        this.build(document, aspect);
        return aspect;
    }
}

