/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.document.aspect.document.pdf.common;

import de.intarsys.document.aspect.IAspect;
import de.intarsys.document.aspect.document.pdf.common.PDFAspectProvider;
import de.intarsys.document.aspect.type.common.BookmarksAspect;
import de.intarsys.document.aspect.type.common.BookmarksAspectType;
import de.intarsys.document.aspect.type.common.DtoNode;
import de.intarsys.document.model.IDocument;
import de.intarsys.document.type.pdf.PDFDocument;
import de.intarsys.pdf.pd.PDDocument;
import de.intarsys.pdf.pd.PDOutline;
import de.intarsys.pdf.pd.PDOutlineItem;
import de.intarsys.tools.functor.IArgs;
import jakarta.ws.rs.InternalServerErrorException;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;

public class BookmarksAspectProvider
extends PDFAspectProvider {
    public BookmarksAspectProvider(@Autowired BookmarksAspectType type) {
        super(type);
    }

    protected void build(IDocument document, BookmarksAspect aspect) {
        try {
            PDDocument pdDoc = (PDDocument)((PDFDocument)document).getImpl();
            DtoNode result = new DtoNode();
            PDOutline outline = pdDoc.getOutline();
            if (outline != null) {
                this.createNodes(result, outline.getChildren());
            }
            aspect.setNode(result);
        }
        catch (Exception e) {
            throw new InternalServerErrorException("error reading PDF document", (Throwable)e);
        }
    }

    protected DtoNode createNode(PDOutlineItem item) {
        DtoNode result = new DtoNode(item.getTitle());
        this.createNodes(result, item.getChildren());
        return result;
    }

    protected void createNodes(DtoNode node, List<PDOutlineItem> items) {
        for (PDOutlineItem item : items) {
            node.addChild(this.createNode(item));
        }
    }

    @Override
    public IAspect getAspect(IDocument document, IArgs args) {
        BookmarksAspect aspect = new BookmarksAspect(this.getType(), document);
        this.build(document, aspect);
        return aspect;
    }
}

