/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.document.aspect.document.pdf.common;

import de.intarsys.document.aspect.document.pdf.common.IAnnotationCollector;
import de.intarsys.document.aspect.type.annotation.AnnotationsAspect;
import de.intarsys.document.aspect.type.annotation.DtoAnnotationControl;
import de.intarsys.document.aspect.type.annotation.DtoRectangle;
import de.intarsys.pdf.cds.CDSRectangle;
import de.intarsys.pdf.pd.PDPage;
import de.intarsys.pdf.tools.kernel.PDFGeometryTools;
import de.intarsys.tools.functor.IArgs;
import de.intarsys.tools.functor.IArgsAccess;
import de.intarsys.tools.string.StringTools;
import java.util.function.Predicate;
import java.util.regex.Pattern;

public abstract class CommonAnnotationsCollector
implements IAnnotationCollector,
IArgsAccess {
    private IArgs args;

    protected void addIfApplicable(AnnotationsAspect aspect, Predicate<DtoAnnotationControl> filter, DtoAnnotationControl control) {
        if (filter.test(control)) {
            aspect.addAnnotationControl(control);
        } else {
            aspect.addKnownAnnotationControl(control);
        }
    }

    protected Predicate<DtoAnnotationControl> createFilter(IArgs args) {
        Object argFilter = args.get("filter");
        if (argFilter == null) {
            return new Predicate<DtoAnnotationControl>(){

                @Override
                public boolean test(DtoAnnotationControl t) {
                    return true;
                }
            };
        }
        if (argFilter instanceof IArgs) {
            final Object argMatch = ((IArgs)argFilter).get("match");
            if (argMatch instanceof IArgs) {
                return new Predicate<DtoAnnotationControl>(){

                    @Override
                    public boolean test(DtoAnnotationControl t) {
                        for (IArgs.IBinding binding : (IArgs)argMatch) {
                            String name = binding.getName();
                            Object value = binding.getValue();
                            if (CommonAnnotationsCollector.this.evaluateFieldPredicate(t.getProperty(name), value)) continue;
                            return false;
                        }
                        return true;
                    }
                };
            }
            throw new IllegalArgumentException("filter type not supported");
        }
        throw new IllegalArgumentException("filter type not supported");
    }

    protected DtoRectangle createRectangle(PDPage page, CDSRectangle rect) {
        CDSRectangle tmpRect = PDFGeometryTools.applyPageSpace((PDPage)page, (CDSRectangle)rect);
        return new DtoRectangle(tmpRect.getLowerLeftX(), tmpRect.getLowerLeftY(), tmpRect.getWidth(), tmpRect.getHeight());
    }

    protected boolean evaluateFieldPredicate(Object actual, Object compare) {
        if (compare == null) {
            return true;
        }
        String string = String.valueOf(compare);
        if (StringTools.isEmpty((String)string)) {
            return true;
        }
        if (actual == null) {
            return false;
        }
        if (string.startsWith("!")) {
            return !Pattern.matches(string.substring(1), actual.toString());
        }
        return Pattern.matches(string, actual.toString());
    }

    public IArgs getArgs() {
        return this.args;
    }

    public void setArgs(IArgs args) {
        this.args = args;
    }
}

