/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.document.aspect.document.pdf.common;

import de.intarsys.document.aspect.document.pdf.common.CommonAnnotationsCollector;
import de.intarsys.document.aspect.type.annotation.AnnotationsAspect;
import de.intarsys.document.aspect.type.annotation.DtoAnnotationAppearance;
import de.intarsys.document.aspect.type.annotation.DtoAnnotationControl;
import de.intarsys.document.model.IDocument;
import de.intarsys.document.type.pdf.PDFDocument;
import de.intarsys.pdf.cds.CDSDate;
import de.intarsys.pdf.pd.PDAFSignatureField;
import de.intarsys.pdf.pd.PDAcroFormField;
import de.intarsys.pdf.pd.PDAnnotation;
import de.intarsys.pdf.pd.PDDocument;
import de.intarsys.pdf.pd.PDMarkupAnnotation;
import de.intarsys.pdf.pd.PDPage;
import de.intarsys.pdf.pd.PDPageTree;
import de.intarsys.pdf.pd.PDPopupAnnotation;
import de.intarsys.pdf.pd.PDWidgetAnnotation;
import jakarta.ws.rs.InternalServerErrorException;
import java.util.List;
import java.util.function.Predicate;

public class PdfAnnotationsCollector
extends CommonAnnotationsCollector {
    @Override
    public void collect(IDocument document, AnnotationsAspect aspect) {
        Predicate<DtoAnnotationControl> filter = this.createFilter(this.getArgs());
        try {
            PDDocument pdDoc = (PDDocument)((PDFDocument)document).getImpl();
            PDPageTree tree = pdDoc.getPageTree();
            PDPage page = tree.getFirstPage();
            int index = 0;
            while (page != null) {
                List annots = page.getAnnotations();
                if (annots != null) {
                    for (PDAnnotation annot : annots) {
                        DtoAnnotationControl control;
                        String name = annot.getName();
                        if (annot instanceof PDWidgetAnnotation) {
                            PDWidgetAnnotation widget = (PDWidgetAnnotation)annot;
                            PDAcroFormField field = widget.getAcroFormField();
                            name = field.getQualifiedName();
                        }
                        if ((control = aspect.getAnnotationControl(name)) == null) {
                            control = new DtoAnnotationControl(name);
                        }
                        this.mergeAnnotationControl(control, annot);
                        DtoAnnotationAppearance appearance = this.createAnnotationAppearance(page, index, annot);
                        control.addAppearance(appearance);
                        this.addIfApplicable(aspect, filter, control);
                    }
                }
                page = page.getNextPage();
                ++index;
            }
        }
        catch (Exception e) {
            throw new InternalServerErrorException("error reading PDF document", (Throwable)e);
        }
    }

    protected DtoAnnotationAppearance createAnnotationAppearance(PDPage page, int index, PDAnnotation annot) {
        DtoAnnotationAppearance control = new DtoAnnotationAppearance();
        control.setPage(index);
        control.setRectangle(this.createRectangle(page, annot.getNormalizedRectangle()));
        return control;
    }

    protected void mergeAnnotationControl(DtoAnnotationControl control, PDAnnotation annot) {
        control.setType(annot.cosGetSubtype().stringValue());
        control.setModified(CDSDate.format((CDSDate)annot.getModified()));
        control.setContent(annot.getContents());
        if (annot instanceof PDMarkupAnnotation) {
            PDMarkupAnnotation markup = (PDMarkupAnnotation)annot;
            control.setText(markup.getText());
            control.setSubject(markup.getSubject());
            control.setCreated(CDSDate.format((CDSDate)markup.getCreationDate()));
        } else if (annot instanceof PDPopupAnnotation) {
            PDPopupAnnotation popup = (PDPopupAnnotation)annot;
            control.setText(popup.getText());
            control.setSubject(popup.getSubject());
        } else if (annot instanceof PDWidgetAnnotation) {
            PDWidgetAnnotation widget = (PDWidgetAnnotation)annot;
            PDAcroFormField field = widget.getAcroFormField();
            control.setSubType(field.cosGetFieldType().stringValue());
            if (field instanceof PDAFSignatureField) {
                control.setProperty("signed", String.valueOf(((PDAFSignatureField)field).isSigned()));
            }
        }
    }
}

