/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.document.aspect.document.pdf.common;

import de.intarsys.document.aspect.document.pdf.common.CommonAnnotationsCollector;
import de.intarsys.document.aspect.type.annotation.AnnotationsAspect;
import de.intarsys.document.aspect.type.annotation.DtoAnnotationAppearance;
import de.intarsys.document.aspect.type.annotation.DtoAnnotationControl;
import de.intarsys.document.aspect.type.annotation.DtoRectangle;
import de.intarsys.document.model.IDocument;
import de.intarsys.tools.exception.ExceptionTools;
import de.intarsys.tools.expression.ExpressionEvaluator;
import de.intarsys.tools.expression.Mode;
import de.intarsys.tools.expression.TagResolver;
import de.intarsys.tools.functor.ArgTools;
import de.intarsys.tools.functor.Args;
import de.intarsys.tools.functor.IArgs;
import de.intarsys.tools.geometry.GeometryTools;
import de.intarsys.tools.string.StringTools;
import de.intarsys.tools.tag.Tag;
import de.intarsys.tools.tag.TagList;
import de.intarsys.tools.tag.TagTools;
import de.intarsys.widget.common.WidgetTools;
import de.intarsys.widget.model.ICallbackSupport;
import java.awt.geom.Point2D;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import java.util.function.Predicate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TagsAnnotationsCollector
extends CommonAnnotationsCollector {
    private static final Logger Log = LoggerFactory.getLogger(TagsAnnotationsCollector.class);
    private static final Set<String> KNOWN_PROPERTIES = new HashSet<String>();
    private String tagPrefix = "annot";

    protected void collect(DtoAnnotationControl control, Tag tag, IArgs tagArgs, IArgs template) {
        String type = this.getProperty(tag, tagArgs, template, "type", control.getType());
        String subType = this.getProperty(tag, tagArgs, template, "subType", control.getSubType());
        control.setType(type);
        control.setSubType(subType);
        if ("Sig".equals(subType) && control.getProperty("signed") == null) {
            control.setProperty("signed", false);
        }
        for (IArgs.IBinding binding : tagArgs) {
            String propertyName = binding.getName();
            if (KNOWN_PROPERTIES.contains(propertyName) || propertyName.startsWith("on-")) continue;
            Object propertyValue = binding.getValue();
            control.setProperty(propertyName, propertyValue);
        }
        WidgetTools.defineCallbacks((ICallbackSupport)control, (IArgs)tagArgs);
        Point2D positionPoint = new Point2D.Float(0.0f, 0.0f);
        String position = this.getProperty(tag, tagArgs, template, "position", null);
        String size = this.getProperty(tag, tagArgs, template, "size", null);
        String pageName = this.getProperty(tag, tagArgs, template, "page", "0");
        if (!StringTools.isEmpty((String)position)) {
            positionPoint = GeometryTools.parsePoint((String)position);
        } else {
            String llx = this.getProperty(tag, tagArgs, template, "llx", "0");
            String lly = this.getProperty(tag, tagArgs, template, "lly", "0");
            positionPoint.setLocation(Float.parseFloat(llx), Float.parseFloat(lly));
        }
        Point2D sizePoint = new Point2D.Float(0.0f, 0.0f);
        if (!StringTools.isEmpty((String)size)) {
            sizePoint = GeometryTools.parsePoint((String)size);
        } else {
            String width = this.getProperty(tag, tagArgs, template, "width", "100");
            String height = this.getProperty(tag, tagArgs, template, "height", "100");
            sizePoint.setLocation(Float.parseFloat(width), Float.parseFloat(height));
        }
        DtoRectangle dtoRect = new DtoRectangle();
        dtoRect.setX((float)positionPoint.getX());
        dtoRect.setY((float)positionPoint.getY());
        dtoRect.setWidth((float)sizePoint.getX());
        dtoRect.setHeight((float)sizePoint.getY());
        int index = Integer.parseInt(pageName);
        DtoAnnotationAppearance appearance = new DtoAnnotationAppearance();
        appearance.setPage(index);
        appearance.setRectangle(dtoRect);
        control.addAppearance(appearance);
    }

    @Override
    public void collect(IDocument document, AnnotationsAspect aspect) {
        TagList tags = this.createTagList();
        if (tags == null) {
            Log.debug("TagsAnnotationCollector no tags found");
            return;
        }
        Predicate<DtoAnnotationControl> filter = this.createFilter(this.getArgs());
        IArgs template = ArgTools.getArgs((IArgs)this.getArgs(), (String)"template", (IArgs)Args.create());
        for (Tag tag : tags.getTags()) {
            String suffix;
            String name;
            DtoAnnotationControl control;
            if (StringTools.isEmpty((String)tag.getKey()) || !tag.getKey().startsWith(this.getTagPrefix() + ".")) continue;
            IArgs tagArgs = null;
            try {
                tagArgs = ArgTools.toArgs((Object)tag.getValue());
            }
            catch (Exception e) {
                Throwable unwrapped = ExceptionTools.unwrap((Throwable)e);
                String errorMsg = ExceptionTools.getMessage((Throwable)unwrapped);
                Log.warn("TagsAnnotationCollector failed to parse {} ({})", (Object)tag.getValue(), (Object)errorMsg);
            }
            if (tagArgs == null) {
                tagArgs = Args.create();
            }
            if ((control = aspect.getAnnotationControl(name = this.getProperty(tag, tagArgs, template, "name", suffix = tag.getKey().substring(this.getTagPrefix().length() + 1)))) == null) {
                control = new DtoAnnotationControl(name);
                control.setType("Widget");
                control.setSubType("Sig");
            }
            this.collect(control, tag, tagArgs, template);
            this.addIfApplicable(aspect, filter, control);
        }
    }

    protected TagList createTagList() {
        try {
            Object target;
            Object resolver = ExpressionEvaluator.get((Mode)Mode.UNTRUSTED).evaluate("tags", (IArgs)Args.create());
            if (resolver instanceof TagResolver && (target = ((TagResolver)resolver).getObject()) instanceof TagList) {
                return (TagList)target;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }

    protected String getProperty(Tag tag, IArgs annotationArgs, IArgs template, String property, String defaultValue) {
        String value = ArgTools.getString((IArgs)annotationArgs, (String)property, null);
        if (StringTools.isEmpty((String)value)) {
            Object tmpValue = TagTools.getTagMeta((Tag)tag, (String)property, null);
            String string = value = tmpValue == null ? null : tmpValue.toString();
        }
        if (StringTools.isEmpty((String)value)) {
            value = ArgTools.getString((IArgs)template, (String)property, (String)defaultValue);
        }
        return value;
    }

    public String getTagPrefix() {
        return this.tagPrefix;
    }

    protected String getTagValue(TagList tags, String key) {
        return TagTools.getTagValue((Object)tags, (String)key, null);
    }

    public void setTagPrefix(String tagPrefix) {
        if (StringTools.isEmpty((String)tagPrefix)) {
            throw new IllegalArgumentException("tagPrefix cannot be empty");
        }
        this.tagPrefix = tagPrefix;
    }

    static {
        Collections.addAll(KNOWN_PROPERTIES, "name", "position", "size", "page", "type", "subType", "width", "height", "callbacks");
    }
}

