/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.document.aspect.document.pdf.print;

import de.intarsys.document.aspect.IAspect;
import de.intarsys.document.aspect.document.pdf.common.PDFAspectProvider;
import de.intarsys.document.aspect.document.pdf.print.PDFPrintScriptInjector;
import de.intarsys.document.model.IDocument;
import de.intarsys.documents.aspect.type.printer.PrinterAspect;
import de.intarsys.documents.aspect.type.printer.PrinterAspectType;
import de.intarsys.pdf.pd.PDDocument;
import de.intarsys.security.document.type.pdf.common.PDFSecurityEnvironment;
import de.intarsys.tools.functor.IArgs;
import de.intarsys.tools.locator.ILocator;
import de.intarsys.tools.reflect.ObjectCreationException;
import java.io.IOException;
import org.springframework.beans.factory.annotation.Autowired;

public class PrintAspectProvider
extends PDFAspectProvider {
    public static final String PDF = "pdf";

    protected PrintAspectProvider(@Autowired PrinterAspectType type) {
        super(type);
    }

    @Override
    public IAspect getAspect(IDocument document, IArgs args) throws ObjectCreationException {
        PrinterAspect aspect = new PrinterAspect(this.getType(), document);
        PDDocument pdDocument = null;
        ILocator tempLocator = null;
        try {
            pdDocument = PDDocument.createFromLocator((ILocator)document.getLocator());
            tempLocator = PDFSecurityEnvironment.get().getTransientLocatorFactory().createLocator(document.getLocator());
            PDFPrintScriptInjector injector = new PDFPrintScriptInjector(pdDocument);
            injector.run();
            pdDocument.save(tempLocator);
            aspect.setFormat(PDF);
            aspect.setLocator(tempLocator);
            PrinterAspect printerAspect = aspect;
            return printerAspect;
        }
        catch (Exception e) {
            if (tempLocator != null) {
                try {
                    tempLocator.delete();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
            throw new ObjectCreationException("error printing document", (Throwable)e);
        }
        finally {
            if (pdDocument != null) {
                try {
                    pdDocument.close();
                }
                catch (IOException iOException) {}
            }
        }
    }
}

