/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.document.aspect.document.pdf.rendering;

import de.intarsys.cwt.awt.environment.CwtAwtGraphicsContext;
import de.intarsys.cwt.environment.IGraphicsContext;
import de.intarsys.document.aspect.IAspect;
import de.intarsys.document.aspect.document.pdf.common.PDFAspectProvider;
import de.intarsys.document.aspect.type.rendering.AnnotationRenderingAspect;
import de.intarsys.document.aspect.type.rendering.AnnotationRenderingAspectType;
import de.intarsys.document.aspect.type.rendering.RenderingParameters;
import de.intarsys.document.aspect.type.rendering.RenderingTools;
import de.intarsys.document.model.IDocument;
import de.intarsys.pdf.app.annotation.AnnotationOutlet;
import de.intarsys.pdf.app.annotation.IAnnotationFactory;
import de.intarsys.pdf.app.appearance.AppearanceCreatorTools;
import de.intarsys.pdf.app.appearance.IAppearanceCreator;
import de.intarsys.pdf.design.shape.ShapeAppearanceCreator;
import de.intarsys.pdf.design.shape.ShapeFactories;
import de.intarsys.pdf.design.widget.AnnotationDefinition;
import de.intarsys.pdf.design.widget.IFieldDefinition;
import de.intarsys.pdf.pd.PDAnnotation;
import de.intarsys.pdf.pd.PDDocument;
import de.intarsys.pdf.pd.PDMarkupAnnotation;
import de.intarsys.pdf.pd.PDPage;
import de.intarsys.pdf.pd.PDPageNode;
import de.intarsys.pdf.rendering.misc.FieldContentRenderer;
import de.intarsys.tools.collection.ListTools;
import de.intarsys.tools.form.model.CommonField;
import de.intarsys.tools.form.model.FieldValue;
import de.intarsys.tools.form.model.Form;
import de.intarsys.tools.functor.ArgTools;
import de.intarsys.tools.functor.Args;
import de.intarsys.tools.functor.IArgs;
import de.intarsys.tools.reflect.ObjectCreationException;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.util.Collections;
import java.util.HashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;

public class AnnotationRenderingAspectProvider
extends PDFAspectProvider {
    private static final Logger Log = LoggerFactory.getLogger(AnnotationRenderingAspectProvider.class);

    public AnnotationRenderingAspectProvider(@Autowired AnnotationRenderingAspectType type) {
        super(type);
    }

    protected PDAnnotation createAnnotation(AnnotationDefinition annotationDefinition) throws ObjectCreationException {
        IAppearanceCreator appearanceCreator = this.createAppearanceCreator(annotationDefinition);
        IAnnotationFactory factory = this.createAnnotationFactory(annotationDefinition);
        PDDocument doc = PDDocument.createNew();
        PDPage page = (PDPage)PDPage.META.createNew();
        doc.addPageNode((PDPageNode)page);
        PDPage.META.createNew();
        PDAnnotation result = factory.createAnnotation(page, annotationDefinition.createRect(), new HashMap());
        AppearanceCreatorTools.setTextFormatProvider((PDAnnotation)result, null);
        AppearanceCreatorTools.createAppearance((PDAnnotation)result, (IAppearanceCreator)appearanceCreator);
        return result;
    }

    protected AnnotationDefinition createAnnotationDefinition(IFieldDefinition fieldDefinition, IArgs args) {
        return new AnnotationDefinition(fieldDefinition, args);
    }

    protected IAnnotationFactory createAnnotationFactory(AnnotationDefinition annotationDefinition) {
        return AnnotationOutlet.get().lookupAnnotationFactory(PDMarkupAnnotation.CN_Subtype_Ink);
    }

    protected IAppearanceCreator createAppearanceCreator(AnnotationDefinition annotationDefinition) {
        ShapeAppearanceCreator creator = new ShapeAppearanceCreator();
        creator.setShape(annotationDefinition.createShape());
        creator.setEmbedFonts(false);
        return creator;
    }

    protected IArgs createArgsAnnotation(FieldValue fieldValue) {
        CommonField field = fieldValue.getField();
        Form form = field.getForm();
        Args annotationArgs = Args.create();
        annotationArgs.put("adjustForRotate", (Object)true);
        annotationArgs.put("x", (Object)Float.valueOf(field.getX()));
        annotationArgs.put("y", (Object)Float.valueOf(field.getY()));
        annotationArgs.put("width", (Object)Float.valueOf(field.getWidth()));
        annotationArgs.put("height", (Object)Float.valueOf(field.getHeight()));
        annotationArgs.put("pageRange", (Object)field.getPageRange());
        annotationArgs.put("annotationType", field.getProperty("annotationType", form.getProperty("annotationType", null)));
        de.intarsys.pdf.design.shape.Shape shape = this.createShape(fieldValue);
        if (shape != null) {
            annotationArgs.put("shapes", (Object)ListTools.with((Object[])new de.intarsys.pdf.design.shape.Shape[]{shape}));
            annotationArgs.put("hResize", (Object)shape.getAlignment().getHorizontalResize());
            annotationArgs.put("vResize", (Object)shape.getAlignment().getVerticalResize());
        } else {
            annotationArgs.put("shapes", Collections.emptyList());
        }
        return annotationArgs;
    }

    protected de.intarsys.pdf.design.shape.Shape createShape(FieldValue fieldValue) {
        return ShapeFactories.createShape((FieldValue)fieldValue);
    }

    @Override
    public IAspect getAspect(IDocument document, IArgs args) {
        AnnotationRenderingAspect aspect = new AnnotationRenderingAspect(this.getType(), document);
        IArgs argFieldValue = ArgTools.getArgs((IArgs)args, (String)"fieldValue", null);
        FieldValue fieldValue = FieldValue.createFromArgs((IArgs)argFieldValue);
        if (fieldValue == null) {
            return aspect;
        }
        IArgs annotationArgs = this.createArgsAnnotation(fieldValue);
        AnnotationDefinition annotDef = this.createAnnotationDefinition(null, annotationArgs);
        try {
            PDAnnotation annotation = this.createAnnotation(annotDef);
            FieldContentRenderer renderer = new FieldContentRenderer();
            double width = annotation.getRectangle().getWidth();
            double height = annotation.getRectangle().getHeight();
            int scale = 1;
            int imgWidth = Math.abs((int)(width * (double)scale));
            int imgHeight = Math.abs((int)(height * (double)scale));
            BufferedImage bufferedImage = new BufferedImage(imgWidth, imgHeight, 1);
            Graphics2D graphics = (Graphics2D)bufferedImage.getGraphics();
            CwtAwtGraphicsContext cwtGraphics = new CwtAwtGraphicsContext(graphics);
            cwtGraphics.setBackgroundColor(Color.WHITE);
            cwtGraphics.fill((Shape)new Rectangle2D.Double(0.0, 0.0, imgWidth, imgHeight));
            AffineTransform transform = new AffineTransform();
            transform.scale(scale, -scale);
            transform.translate(0.0, -height);
            cwtGraphics.transform(transform);
            renderer.renderAnnotation(annotation, null, new HashMap(), (IGraphicsContext)cwtGraphics);
            Object oRenderingParameters = ArgTools.getObject((IArgs)args, (String)"renderingParameters", null);
            RenderingParameters renderingParameters = oRenderingParameters instanceof RenderingParameters ? (RenderingParameters)oRenderingParameters : new RenderingParameters();
            byte[] bytes = RenderingTools.writeImage(bufferedImage, renderingParameters);
            aspect.setBytes(bytes);
            aspect.setFormat(renderingParameters.getFormat());
        }
        catch (Exception e) {
            Log.info("failed", (Throwable)e);
        }
        return aspect;
    }
}

