/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.document.aspect.document.pdf.rendering;

import de.intarsys.cwt.awt.environment.CwtAwtGraphicsContext;
import de.intarsys.cwt.environment.IGraphicsContext;
import de.intarsys.document.aspect.document.pdf.rendering.JavaRenderer;
import de.intarsys.document.aspect.document.pdf.rendering.PageBasedImageDetails;
import de.intarsys.document.aspect.type.rendering.RenderingParameters;
import de.intarsys.document.type.pdf.PDFDocument;
import de.intarsys.pdf.rendering.misc.FieldContentRenderer;
import de.intarsys.pdf.rendering.misc.PageContentRenderer;
import de.intarsys.pdf.rendering.page.IPageRenderer;
import java.awt.Graphics2D;
import java.awt.geom.AffineTransform;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CwtPdfRenderer
extends JavaRenderer {
    private static final Logger Log = LoggerFactory.getLogger(CwtPdfRenderer.class);

    public CwtPdfRenderer(PDFDocument document, int pageIndex, RenderingParameters renderParams) {
        super(new PageBasedImageDetails(document, pageIndex, renderParams));
    }

    @Override
    public PageBasedImageDetails getImageDetails() {
        return (PageBasedImageDetails)super.getImageDetails();
    }

    @Override
    protected void renderContent(Graphics2D graphics) {
        graphics.translate(0, this.getImageDetails().getImageDimension().height);
        graphics.scale(this.getImageDetails().getScale(), -this.getImageDetails().getScale());
        graphics.transform(this.getImageDetails().getRotateTransform());
        IPageRenderer[] pageRenderers = new IPageRenderer[]{new PageContentRenderer(), new FieldContentRenderer()};
        CwtAwtGraphicsContext cwtGraphics = new CwtAwtGraphicsContext(graphics);
        AffineTransform transform = graphics.getTransform();
        for (IPageRenderer renderer : pageRenderers) {
            try {
                renderer.renderPage(this.getImageDetails().getPage(), null, (IGraphicsContext)cwtGraphics);
            }
            catch (Exception ex) {
                Log.warn("Error rendering page", (Throwable)ex);
            }
            cwtGraphics.setTransform(transform);
        }
    }
}

