/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.document.aspect.document.pdf.rendering;

import de.intarsys.document.aspect.IAspect;
import de.intarsys.document.aspect.document.pdf.common.PDFAspectProvider;
import de.intarsys.document.aspect.document.pdf.rendering.IRenderer;
import de.intarsys.document.aspect.document.pdf.rendering.MessageRenderer;
import de.intarsys.document.aspect.type.rendering.DocumentRenderingAspect;
import de.intarsys.document.aspect.type.rendering.DocumentRenderingAspectType;
import de.intarsys.document.aspect.type.rendering.RenderingParameters;
import de.intarsys.document.aspect.type.rendering.RenderingTools;
import de.intarsys.document.model.IDocument;
import de.intarsys.document.type.pdf.PDFDocument;
import de.intarsys.tools.concurrent.ThreadTools;
import de.intarsys.tools.exception.ExceptionTools;
import de.intarsys.tools.functor.ArgTools;
import de.intarsys.tools.functor.IArgs;
import jakarta.ws.rs.InternalServerErrorException;
import java.awt.image.BufferedImage;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.ApplicationContext;

public class DocumentRenderingAspectProvider
extends PDFAspectProvider {
    private static final Logger Log = LoggerFactory.getLogger(DocumentRenderingAspectProvider.class);
    private static final ExecutorService executor = Executors.newCachedThreadPool(ThreadTools.newThreadFactory((String)"rendering"));
    private static final int MAX_TIMEOUT = 60;
    private static final String PDF_RENDERER_FALLBACK = "pdfRendererCwt";
    @Autowired
    private ApplicationContext applicationContext;
    @Value(value="${viewer.rendering.pdfRenderer:pdfRendererPdfium}")
    private String pdfRenderer;
    private int timeout = 20;

    public DocumentRenderingAspectProvider(@Autowired DocumentRenderingAspectType type) {
        super(type);
    }

    protected byte[] createImage(IDocument document, int pageIndex, RenderingParameters renderParams, boolean fast) {
        IRenderer renderer;
        try {
            if (fast) {
                renderer = new MessageRenderer("Rendering timeout", (PDFDocument)document, pageIndex, renderParams);
            } else {
                try {
                    renderer = (IRenderer)this.applicationContext.getBean(this.pdfRenderer, new Object[]{document, pageIndex, renderParams});
                }
                catch (BeansException ex) {
                    Log.warn(ex.getMessage(), (Throwable)ex);
                    renderer = (IRenderer)this.applicationContext.getBean(PDF_RENDERER_FALLBACK, new Object[]{document, pageIndex, renderParams});
                }
            }
        }
        catch (Exception ex) {
            try {
                renderer = new MessageRenderer(ex.getMessage(), renderParams);
            }
            catch (Exception ignore) {
                renderer = new MessageRenderer(ex.getMessage(), new RenderingParameters());
            }
        }
        try {
            BufferedImage image = renderer.createImage();
            return RenderingTools.writeImage(image, renderParams);
        }
        catch (Exception ex) {
            throw new InternalServerErrorException("error rendering PDF document", (Throwable)ex);
        }
    }

    @Override
    public IAspect getAspect(IDocument document, IArgs args) {
        byte[] bs;
        Object oRenderingParameters;
        DocumentRenderingAspect aspect = new DocumentRenderingAspect(this.getType(), document);
        int index = ArgTools.getIntStrict((IArgs)args, (String)"pageIndex", (int)1);
        int currentTimeout = this.getTimeout();
        Object requestedTimeout = ArgTools.getObject((IArgs)args, (String)"timeout", null);
        if (requestedTimeout instanceof Number) {
            currentTimeout = ((Number)requestedTimeout).intValue();
        }
        if (currentTimeout <= 0) {
            currentTimeout = 60;
        }
        RenderingParameters renderingParameters = (oRenderingParameters = ArgTools.getObject((IArgs)args, (String)"renderingParameters", null)) instanceof RenderingParameters ? (RenderingParameters)oRenderingParameters : new RenderingParameters();
        Future<byte[]> submit = executor.submit(() -> this.createImage(document, index, renderingParameters, false));
        try {
            bs = submit.get(currentTimeout, TimeUnit.SECONDS);
        }
        catch (TimeoutException e) {
            Log.debug("rendering timeout");
            submit.cancel(true);
            bs = this.createImage(document, index, renderingParameters, true);
        }
        catch (Exception e) {
            throw ExceptionTools.wrap((Throwable)e);
        }
        aspect.setBytes(bs);
        aspect.setFormat(renderingParameters.getFormat());
        return aspect;
    }

    public int getTimeout() {
        return this.timeout;
    }

    public void setPdfRenderer(String pdfRenderer) {
        this.pdfRenderer = pdfRenderer;
    }

    public void setTimeout(int timeout) {
        this.timeout = timeout;
    }
}

