/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.document.aspect.document.pdf.rendering;

import de.intarsys.document.aspect.type.rendering.RenderingParameters;
import java.awt.Dimension;
import java.util.Objects;

public class ImageDetails {
    private Dimension imageDimension;
    private ImageType imageType;
    private RenderingParameters renderParams;
    private double scale;

    public ImageDetails(RenderingParameters renderParams) {
        this.renderParams = Objects.requireNonNull(renderParams);
        this.imageType = ImageType.valueOf(renderParams.getType().toUpperCase());
        this.scale = (double)renderParams.getScale() / 100.0;
    }

    public Dimension getImageDimension() {
        return this.imageDimension;
    }

    public ImageType getImageType() {
        return this.imageType;
    }

    public RenderingParameters getRenderParams() {
        return this.renderParams;
    }

    public double getScale() {
        return this.scale;
    }

    protected void setImageDimension(Dimension imageDimension) {
        this.imageDimension = imageDimension;
    }

    public static enum ImageType {
        BINARY,
        GRAY,
        INDEXED,
        RGB;

    }
}

