/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.document.aspect.document.pdf.rendering;

import de.intarsys.document.aspect.document.pdf.rendering.AbstractRenderer;
import de.intarsys.document.aspect.document.pdf.rendering.ImageDetails;
import de.intarsys.tools.exception.UnreachableCodeError;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.image.BufferedImage;

public abstract class JavaRenderer
extends AbstractRenderer {
    public JavaRenderer(ImageDetails imageDetails) {
        super(imageDetails);
    }

    public BufferedImage createBlankImage() {
        int imageType = switch (this.getImageDetails().getImageType()) {
            case ImageDetails.ImageType.BINARY -> 12;
            case ImageDetails.ImageType.GRAY -> 10;
            case ImageDetails.ImageType.INDEXED -> 13;
            case ImageDetails.ImageType.RGB -> 1;
            default -> throw new UnreachableCodeError();
        };
        Dimension imageDimension = this.getImageDetails().getImageDimension();
        BufferedImage image = new BufferedImage(imageDimension.width, imageDimension.height, imageType);
        return image;
    }

    @Override
    public BufferedImage createImage() {
        BufferedImage image = this.createBlankImage();
        Graphics2D graphics = (Graphics2D)image.getGraphics();
        try {
            this.renderContent(graphics);
        }
        finally {
            graphics.dispose();
        }
        return image;
    }

    protected abstract void renderContent(Graphics2D var1);
}

