/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.document.aspect.document.pdf.rendering;

import de.intarsys.document.aspect.document.pdf.rendering.ImageDetails;
import de.intarsys.document.aspect.document.pdf.rendering.JavaRenderer;
import de.intarsys.document.aspect.document.pdf.rendering.PageBasedImageDetails;
import de.intarsys.document.aspect.document.pdf.rendering.PlainImageDetails;
import de.intarsys.document.aspect.type.rendering.RenderingParameters;
import de.intarsys.document.type.pdf.PDFDocument;
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.geom.Rectangle2D;

public class MessageRenderer
extends JavaRenderer {
    private String message;

    public MessageRenderer(String message, ImageDetails imageDetails) {
        super(imageDetails);
        this.message = message;
    }

    public MessageRenderer(String message, PDFDocument document, int pageIndex, RenderingParameters renderParams) {
        this(message, new PageBasedImageDetails(document, pageIndex, renderParams));
    }

    public MessageRenderer(String message, RenderingParameters renderParams) {
        this(message, new PlainImageDetails(renderParams));
    }

    @Override
    public void renderContent(Graphics2D graphics) {
        graphics.setBackground(Color.WHITE);
        graphics.fill(new Rectangle2D.Double(0.0, 0.0, this.getImageDetails().getImageDimension().width, this.getImageDetails().getImageDimension().height));
        graphics.setColor(Color.BLACK);
        double scale = this.getImageDetails().getScale();
        Font font = graphics.getFont();
        font = new Font(font.getFontName(), font.getStyle(), (int)((double)font.getSize() * scale));
        graphics.setFont(font);
        graphics.drawString(this.message, (int)(100.0 * scale), Math.max(this.getImageDetails().getImageDimension().height - (int)(100.0 * scale), 0));
    }
}

