/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.document.aspect.document.pdf.rendering;

import de.intarsys.document.aspect.document.pdf.rendering.ImageDetails;
import de.intarsys.document.aspect.type.rendering.RenderingParameters;
import de.intarsys.document.type.pdf.PDFDocument;
import de.intarsys.pdf.pd.PDDocument;
import de.intarsys.pdf.pd.PDPage;
import de.intarsys.pdf.tools.kernel.PDFGeometryTools;
import java.awt.Dimension;
import java.awt.geom.AffineTransform;
import java.awt.geom.Rectangle2D;
import java.util.Objects;

public class PageBasedImageDetails
extends ImageDetails {
    private PDFDocument document;
    private PDPage page;
    private int pageIndex;
    private Rectangle2D pageRect;
    private AffineTransform rotateTransform;

    public PageBasedImageDetails(PDFDocument document, int pageIndex, RenderingParameters renderParams) {
        super(renderParams);
        this.document = Objects.requireNonNull(document);
        this.pageIndex = pageIndex;
        PDDocument pdDocument = (PDDocument)document.getImpl();
        this.page = pdDocument.getPageTree().getPageAt(pageIndex);
        if (this.page == null) {
            throw new IllegalArgumentException("invalid page index " + pageIndex);
        }
        this.pageRect = this.page.getCropBox().toNormalizedRectangle();
        this.rotateTransform = PDFGeometryTools.createPageSpace((PDPage)this.page);
        double[] extent = new double[]{this.pageRect.getWidth(), this.pageRect.getHeight()};
        this.getRotateTransform().deltaTransform(extent, 0, extent, 0, 1);
        double width = extent[0] >= 0.0 ? extent[0] : 0.0 - extent[0];
        double height = extent[1] >= 0.0 ? extent[1] : 0.0 - extent[1];
        this.setImageDimension(new Dimension((int)Math.round(width * this.getScale()), (int)Math.round(height * this.getScale())));
    }

    public PDFDocument getDocument() {
        return this.document;
    }

    public PDPage getPage() {
        return this.page;
    }

    public int getPageIndex() {
        return this.pageIndex;
    }

    public AffineTransform getRotateTransform() {
        return this.rotateTransform;
    }
}

