/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.document.aspect.document.pdf.rendering;

import de.intarsys.document.aspect.document.pdf.rendering.AbstractRenderer;
import de.intarsys.document.aspect.document.pdf.rendering.ImageDetails;
import de.intarsys.document.aspect.document.pdf.rendering.PageBasedImageDetails;
import de.intarsys.document.aspect.type.rendering.RenderingParameters;
import de.intarsys.document.type.pdf.PDFDocument;
import de.intarsys.pdfium.FpdfBitmap;
import de.intarsys.pdfium.FpdfDocument;
import de.intarsys.pdfium.FpdfPage;
import de.intarsys.pdfium.Fpdfview;
import de.intarsys.pdfium.PdfiumException;
import de.intarsys.tools.exception.UnreachableCodeError;
import de.intarsys.tools.randomaccess.IRandomAccess;
import java.awt.Dimension;
import java.awt.color.ColorSpace;
import java.awt.image.BufferedImage;
import java.awt.image.ComponentColorModel;
import java.awt.image.DataBufferByte;
import java.awt.image.Raster;
import java.awt.image.WritableRaster;
import java.io.IOException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PdfiumPdfRenderer
extends AbstractRenderer {
    private static final Logger Log = LoggerFactory.getLogger(PdfiumPdfRenderer.class);

    public PdfiumPdfRenderer(PDFDocument document, int pageIndex, RenderingParameters renderParams) {
        super(new PageBasedImageDetails(document, pageIndex, renderParams));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public BufferedImage createImage() {
        try {
            IRandomAccess randomAccess = this.getImageDetails().getDocument().getLocator().getRandomAccess();
            try {
                Class<PdfiumPdfRenderer> clazz = PdfiumPdfRenderer.class;
                synchronized (PdfiumPdfRenderer.class) {
                    Object password = this.getImageDetails().getDocument().getAttribute((Object)"password");
                    BufferedImage bufferedImage = this.createImage(randomAccess, password != null ? password.toString() : null);
                    // ** MonitorExit[var2_3] (shouldn't be in output)
                    return bufferedImage;
                }
            }
            finally {
                try {
                    randomAccess.close();
                }
                catch (IOException iOException) {}
            }
        }
        catch (PdfiumException | IOException ex) {
            Log.warn(ex.getMessage(), ex);
            throw new RuntimeException(ex);
        }
    }

    protected BufferedImage createImage(FpdfDocument fpdfDocument) throws PdfiumException {
        int pixelStride;
        ColorSpace colorSpace;
        int format;
        Dimension imageDimension = this.getImageDetails().getImageDimension();
        int[] bandOffsets = switch (this.getImageDetails().getImageType()) {
            case ImageDetails.ImageType.BINARY, ImageDetails.ImageType.GRAY -> {
                format = 1;
                colorSpace = ColorSpace.getInstance(1003);
                pixelStride = 1;
                yield new int[]{0};
            }
            case ImageDetails.ImageType.INDEXED, ImageDetails.ImageType.RGB -> {
                format = 2;
                colorSpace = ColorSpace.getInstance(1000);
                pixelStride = 3;
                yield new int[]{2, 1, 0};
            }
            default -> throw new UnreachableCodeError();
        };
        try (FpdfPage fpdfPage = fpdfDocument.loadPage(this.getImageDetails().getPageIndex());){
            BufferedImage bufferedImage;
            block16: {
                FpdfBitmap fpdfBitmap = Fpdfview.createBitmap((int)imageDimension.width, (int)imageDimension.height, (int)format);
                try {
                    Fpdfview.fillBitmapRect((FpdfBitmap)fpdfBitmap, (int)imageDimension.width, (int)imageDimension.height, (int)-1);
                    fpdfBitmap.renderPage(fpdfPage, 0, 0, imageDimension.width, imageDimension.height, 1);
                    ComponentColorModel colorModel = new ComponentColorModel(colorSpace, false, false, 1, 0);
                    byte[] buffer = fpdfBitmap.getBuffer();
                    WritableRaster raster = Raster.createInterleavedRaster(new DataBufferByte(buffer, buffer.length), imageDimension.width, imageDimension.height, fpdfBitmap.getStride(), pixelStride, bandOffsets, null);
                    bufferedImage = new BufferedImage(colorModel, raster, true, null);
                    if (fpdfBitmap == null) break block16;
                }
                catch (Throwable throwable) {
                    if (fpdfBitmap != null) {
                        try {
                            fpdfBitmap.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                fpdfBitmap.close();
            }
            return bufferedImage;
        }
    }

    protected BufferedImage createImage(IRandomAccess randomAccess, String password) throws IOException, PdfiumException {
        try (FpdfDocument fpdfDocument = Fpdfview.loadDocument((long)randomAccess.getLength(), (Fpdfview.GetBlockAdapter)new GetBlock(randomAccess), (String)password);){
            BufferedImage bufferedImage = this.createImage(fpdfDocument);
            return bufferedImage;
        }
    }

    @Override
    public PageBasedImageDetails getImageDetails() {
        return (PageBasedImageDetails)super.getImageDetails();
    }

    private static class GetBlock
    extends Fpdfview.GetBlockAdapter {
        private IRandomAccess randomAccess;

        public GetBlock(IRandomAccess randomAccess) {
            this.randomAccess = randomAccess;
        }

        protected void invoke(long position, byte[] buffer) throws IOException {
            this.randomAccess.seek(position);
            this.randomAccess.read(buffer);
        }
    }
}

