/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.document.aspect.document.unknown.rendering;

import de.intarsys.cwt.awt.environment.CwtAwtGraphicsContext;
import de.intarsys.document.aspect.IAspect;
import de.intarsys.document.aspect.common.CommonAspectProvider;
import de.intarsys.document.aspect.type.rendering.DocumentRenderingAspect;
import de.intarsys.document.aspect.type.rendering.DocumentRenderingAspectType;
import de.intarsys.document.aspect.type.rendering.RenderingParameters;
import de.intarsys.document.model.IDocument;
import de.intarsys.tools.functor.ArgTools;
import de.intarsys.tools.functor.IArgs;
import jakarta.ws.rs.InternalServerErrorException;
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.Shape;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RectangularShape;
import java.awt.image.BufferedImage;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import javax.imageio.IIOImage;
import javax.imageio.ImageIO;
import javax.imageio.ImageWriteParam;
import javax.imageio.ImageWriter;
import javax.imageio.stream.MemoryCacheImageOutputStream;
import org.springframework.beans.factory.annotation.Autowired;

public class DocumentRenderingAspectProvider
extends CommonAspectProvider {
    public DocumentRenderingAspectProvider(@Autowired DocumentRenderingAspectType type) {
        super(type);
    }

    protected byte[] createImage(IDocument document, int pageIndex, RenderingParameters renderParams) {
        BufferedImage img = this.renderPage();
        ByteArrayOutputStream os = new ByteArrayOutputStream(100000);
        String format = renderParams.getFormat();
        ImageWriter imgWriter = ImageIO.getImageWritersByFormatName(format).next();
        ImageWriteParam imgParam = imgWriter.getDefaultWriteParam();
        if (imgParam.canWriteCompressed()) {
            imgParam.setCompressionMode(2);
            imgParam.setCompressionQuality((float)((double)renderParams.getCompression() / 100.0));
        }
        MemoryCacheImageOutputStream outputStream = new MemoryCacheImageOutputStream(os);
        imgWriter.setOutput(outputStream);
        IIOImage outputImage = new IIOImage(img, null, null);
        try {
            imgWriter.write(null, outputImage, imgParam);
        }
        catch (IOException e) {
            throw new InternalServerErrorException("error writing image", (Throwable)e);
        }
        imgWriter.dispose();
        return os.toByteArray();
    }

    @Override
    public IAspect getAspect(IDocument document, IArgs args) {
        DocumentRenderingAspect aspect = new DocumentRenderingAspect(this.getType(), document);
        int index = ArgTools.getIntStrict((IArgs)args, (String)"pageIndex", (int)1);
        Object oRenderingParameters = ArgTools.getObject((IArgs)args, (String)"renderingParameters", null);
        RenderingParameters renderingParameters = oRenderingParameters instanceof RenderingParameters ? (RenderingParameters)oRenderingParameters : new RenderingParameters();
        aspect.setBytes(this.createImage(document, index, renderingParameters));
        aspect.setFormat(renderingParameters.getFormat());
        return aspect;
    }

    @Override
    public Class<? extends IDocument> getDocumentClass() {
        return IDocument.class;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected BufferedImage renderPage() {
        Rectangle2D.Double rect = new Rectangle2D.Double(0.0, 0.0, 500.0, 500.0);
        BufferedImage image = null;
        CwtAwtGraphicsContext graphics = null;
        try {
            int imageType = 12;
            image = new BufferedImage((int)((RectangularShape)rect).getWidth(), (int)((RectangularShape)rect).getHeight(), imageType);
            Graphics2D g2 = (Graphics2D)image.getGraphics();
            graphics = new CwtAwtGraphicsContext(g2);
            graphics.setBackgroundColor(Color.WHITE);
            graphics.clip((Shape)rect);
            graphics.fill((Shape)rect);
            graphics.setFont(Font.getFont("Helvetica"));
            graphics.setForegroundColor(Color.BLACK);
            graphics.drawString("Document not supported", 0.0f, 200.0f);
            BufferedImage bufferedImage = image;
            return bufferedImage;
        }
        finally {
            if (graphics != null) {
                graphics.dispose();
            }
        }
    }
}

